/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.string;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import se.unlogic.standardutils.string.TagSource;

public class TagReplacer {
    private List<TagSource> tagSources;

    public TagReplacer() {
        this.tagSources = new ArrayList<TagSource>();
    }

    public TagReplacer(List<TagSource> tagSources) {
        this.tagSources = new ArrayList<TagSource>(tagSources);
    }

    public TagReplacer(TagSource ... tagSources) {
        this.tagSources = new ArrayList<TagSource>(Arrays.asList(tagSources));
    }

    public boolean addTagSource(TagSource o) {
        if (this.tagSources == null) {
            this.tagSources = new ArrayList<TagSource>();
        }
        return this.tagSources.add(o);
    }

    public boolean removeTagSource(TagSource o) {
        if (this.tagSources == null) {
            return false;
        }
        return this.tagSources.remove(o);
    }

    public String replace(String source) {
        for (TagSource tagSource : this.tagSources) {
            for (String tag : tagSource.getTags()) {
                if (!source.contains(tag)) continue;
                String value = tagSource.getTagValue(tag);
                if (value == null) {
                    value = "";
                }
                source = source.replace(tag, value);
            }
        }
        return source;
    }
}

