/*
 * Decompiled with CFR 0.152.
 */
package se.unlogic.standardutils.validation;

import se.unlogic.standardutils.numbers.NumberUtils;
import se.unlogic.standardutils.validation.StringNumberValidator;

public class StringIntegerValidator
extends StringNumberValidator<Integer> {
    public StringIntegerValidator() {
        super(null, null);
    }

    public StringIntegerValidator(Integer minValue, Integer maxValue) {
        super(minValue, maxValue);
    }

    @Override
    public boolean validateFormat(String value) {
        Integer numberValue = NumberUtils.toInt(value);
        if (numberValue == null) {
            return false;
        }
        if (this.maxValue != null && this.minValue != null) {
            return numberValue <= (Integer)this.maxValue && numberValue >= (Integer)this.minValue;
        }
        if (this.maxValue != null) {
            return numberValue <= (Integer)this.maxValue;
        }
        if (this.minValue != null) {
            return numberValue >= (Integer)this.minValue;
        }
        return true;
    }
}

