/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.api.validation;

import javax.validation.ConstraintDeclarationException;
import javax.validation.ConstraintDefinitionException;
import javax.validation.GroupDefinitionException;
import javax.validation.ValidationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.api.validation.ResteasyViolationException;
import org.jboss.resteasy.plugins.providers.SerializableProvider;

@Provider
public class ResteasyViolationExceptionMapper
implements ExceptionMapper<ValidationException> {
    public Response toResponse(ValidationException exception) {
        if (exception instanceof ConstraintDefinitionException) {
            return this.buildResponse(exception, SerializableProvider.APPLICATION_SERIALIZABLE, Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (exception instanceof ConstraintDeclarationException) {
            return this.buildResponse(exception, SerializableProvider.APPLICATION_SERIALIZABLE, Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (exception instanceof GroupDefinitionException) {
            return this.buildResponse(exception, SerializableProvider.APPLICATION_SERIALIZABLE, Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (exception instanceof ResteasyViolationException) {
            ResteasyViolationException resteasyViolationException = (ResteasyViolationException)((Object)ResteasyViolationException.class.cast(exception));
            Exception e = resteasyViolationException.getException();
            if (e != null) {
                return this.buildResponse(e, SerializableProvider.APPLICATION_SERIALIZABLE, Response.Status.INTERNAL_SERVER_ERROR);
            }
            if (resteasyViolationException.getReturnValueViolations().size() == 0) {
                return this.buildResponse(exception, SerializableProvider.APPLICATION_SERIALIZABLE, Response.Status.BAD_REQUEST);
            }
            return this.buildResponse(exception, SerializableProvider.APPLICATION_SERIALIZABLE, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return this.buildResponse(exception, SerializableProvider.APPLICATION_SERIALIZABLE, Response.Status.INTERNAL_SERVER_ERROR);
    }

    protected Response buildResponse(Object entity, String mediaType, Response.Status status) {
        Response.ResponseBuilder builder = Response.status((Response.Status)status).entity(entity);
        builder.type(SerializableProvider.APPLICATION_SERIALIZABLE);
        builder.header("validation-exception", (Object)"true");
        return builder.build();
    }
}

