/*******************************************************************************
 * Copyright (c) 2010 Robert "Unlogic" Olofsson (unlogic@unlogic.se).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0-standalone.html
 ******************************************************************************/
package se.unlogic.standardutils.annotations;

import se.unlogic.standardutils.populators.BeanStringPopulator;
import se.unlogic.standardutils.populators.DummyPopulator;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation is used to annotate fields that are to be populated by the {@link se.unlogic.webutils.populators.annotated.AnnotatedRequestPopulator}.
 *
 * @author Robert "Unlogic" Olofsson (unlogic@unlogic.se)
 *
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.FIELD,ElementType.METHOD})
public @interface WebPopulate {

   String paramName() default "";
   boolean required() default false;
   long maxLength() default 0;
   long minLength() default 0;
   String populatorID() default "";
   boolean trim() default true;
   Class<? extends BeanStringPopulator<?>> populator() default DummyPopulator.class;
}
