package org.jboss.resteasy.test.providers.jackson2.jsonfilter;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.test.providers.jackson2.jsonfilter.resource.Jackson2Product;
import org.jboss.resteasy.test.providers.jackson2.jsonfilter.resource.Jackson2Resource;
import org.jboss.resteasy.test.providers.jackson2.jsonfilter.resource.JsonFilterWriteInterceptor;
import org.jboss.resteasy.test.providers.jackson2.jsonfilter.resource.ObjectFilterModifier;
import org.jboss.resteasy.utils.PortProviderUtil;
import org.jboss.resteasy.utils.TestUtil;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

/**
 * @author <a href="mailto:ema@redhat.com">Jim Ma</a>
 * @tpSubChapter Jackson2 provider
 * @tpChapter Integration tests
 * @tpInfo RESTESY-1442
 * @tpSince RESTEasy  3.0.20.Final
 */
@RunWith(Arquillian.class)
@RunAsClient
public class JsonFilterWithInterceptrTest {

   @Deployment(name = "default")
   public static Archive<?> deploy() {
      WebArchive war = TestUtil.prepareArchive(JsonFilterWithInterceptrTest.class.getSimpleName());
      war.addClasses(Jackson2Product.class, ObjectFilterModifier.class);
      war.addAsManifestResource(new StringAsset("Manifest-Version: 1.0\n" + "Dependencies: com.fasterxml.jackson.jaxrs.jackson-jaxrs-json-provider\n"), "MANIFEST.MF");
      return TestUtil.finishContainerPrepare(war, null, Jackson2Resource.class, JsonFilterWriteInterceptor.class);
   }

   private String generateURL(String path) {
      return PortProviderUtil.generateURL(path, JsonFilterWithInterceptrTest.class.getSimpleName());
   }

   /**
    * @tpTestDetails Filters fields from json response entity using interceptor
    * @tpSince RESTEasy  3.0.20.Final
    */
   @Test
   public void testJacksonString() throws Exception {
      Client client = new ResteasyClientBuilder().build();
      WebTarget target = client.target(generateURL("/products/333"));
      Response response = target.request().get();
      response.bufferEntity();
      Assert.assertTrue("filter doesn't work", !response.readEntity(String.class).contains("id") &&
            response.readEntity(String.class).contains("name"));
      client.close();
   }
}
