/*
 * JBoss, Home of Professional Open Source.
 *
 * Copyright 2024 Red Hat, Inc., and individual contributors
 * as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.resteasy.test.providers.jackson2.objectmapper.resources;

import java.time.Instant;
import java.util.function.Predicate;

import jakarta.enterprise.context.ApplicationScoped;

/**
 * @author <a href="mailto:jperkins@redhat.com">James R. Perkins</a>
 */
@ApplicationScoped
public class UserRepository extends GenericRepository<User> {
    @Override
    protected Predicate<User> findByIdFilter(final long id) {
        return (user) -> user.getId() == id;
    }

    @Override
    protected void beforeAdd(final long id, final User entry) {
        entry.setId(id);
        entry.setCreated(Instant.now());
    }

    @Override
    protected void beforeUpdate(final User entry) {
        entry.setModified(Instant.now());
    }
}
