/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import org.jboss.resteasy.core.InjectorFactoryImpl;
import org.jboss.resteasy.core.ValueInjector;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.ConstructorInjector;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.LoggableFailure;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class ConstructorInjectorImpl
implements ConstructorInjector {
    protected Constructor constructor;
    protected ValueInjector[] params;

    public ConstructorInjectorImpl(Constructor constructor, ResteasyProviderFactory factory) {
        this.constructor = constructor;
        this.params = new ValueInjector[constructor.getParameterTypes().length];
        for (int i = 0; i < constructor.getParameterTypes().length; ++i) {
            Class<?> type = constructor.getParameterTypes()[i];
            Type genericType = constructor.getGenericParameterTypes()[i];
            Annotation[] annotations = constructor.getParameterAnnotations()[i];
            this.params[i] = InjectorFactoryImpl.getParameterExtractor(type, genericType, annotations, constructor, factory);
        }
    }

    public Object[] injectableArguments(HttpRequest input, HttpResponse response) {
        Object[] args = null;
        if (this.params != null && this.params.length > 0) {
            args = new Object[this.params.length];
            int i = 0;
            for (ValueInjector extractor : this.params) {
                args[i++] = extractor.inject(input, response);
            }
        }
        return args;
    }

    public Object[] injectableArguments() {
        Object[] args = null;
        if (this.params != null && this.params.length > 0) {
            args = new Object[this.params.length];
            int i = 0;
            for (ValueInjector extractor : this.params) {
                args[i++] = extractor.inject();
            }
        }
        return args;
    }

    public Object construct(HttpRequest request, HttpResponse httpResponse) throws Failure, ApplicationException, WebApplicationException {
        Object[] args = null;
        try {
            args = this.injectableArguments(request, httpResponse);
        }
        catch (Exception e) {
            throw new LoggableFailure("Failed processing arguments of " + this.constructor.toString(), (Throwable)e, 400);
        }
        try {
            return this.constructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new LoggableFailure("Failed to construct " + this.constructor.toString(), (Throwable)e, 400);
        }
        catch (IllegalAccessException e) {
            throw new LoggableFailure("Failed to construct " + this.constructor.toString(), (Throwable)e, 400);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof WebApplicationException) {
                throw (WebApplicationException)cause;
            }
            throw new ApplicationException("Failed to construct " + this.constructor.toString(), e.getCause());
        }
        catch (IllegalArgumentException e) {
            String msg = "Bad arguments passed to " + this.constructor.toString() + "  (";
            boolean first = false;
            for (Object arg : args) {
                if (!first) {
                    first = true;
                } else {
                    msg = msg + ",";
                }
                msg = arg == null ? msg + " null" : msg + " " + arg;
            }
            throw new LoggableFailure(msg, (Throwable)e, 400);
        }
    }

    public Object construct() {
        Object[] args = null;
        args = this.injectableArguments();
        try {
            return this.constructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Failed to construct " + this.constructor.toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to construct " + this.constructor.toString(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Failed to construct " + this.constructor.toString(), e.getCause());
        }
        catch (IllegalArgumentException e) {
            String msg = "Bad arguments passed to " + this.constructor.toString() + "  (";
            boolean first = false;
            for (Object arg : args) {
                if (!first) {
                    first = true;
                } else {
                    msg = msg + ",";
                }
                msg = arg == null ? msg + " null" : msg + " " + arg;
            }
            throw new RuntimeException(msg, e);
        }
    }
}

