/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.specimpl.PathSegmentImpl;
import org.jboss.resteasy.specimpl.RequestImpl;
import org.jboss.resteasy.specimpl.ResponseImpl;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.LoggableFailure;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.UnhandledException;
import org.jboss.resteasy.util.LocaleHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronousDispatcher
implements Dispatcher {
    protected ResteasyProviderFactory providerFactory;
    protected ResourceMethodRegistry registry;
    protected Map<String, MediaType> mediaTypeMappings;
    protected Map<String, String> languageMappings;
    private static final Logger logger = LoggerFactory.getLogger(SynchronousDispatcher.class);

    public SynchronousDispatcher(ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
        this.registry = new ResourceMethodRegistry(providerFactory);
    }

    @Override
    public ResteasyProviderFactory getProviderFactory() {
        return this.providerFactory;
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    @Override
    public void setMediaTypeMappings(Map<String, MediaType> mediaTypeMappings) {
        this.mediaTypeMappings = mediaTypeMappings;
    }

    @Override
    public void setLanguageMappings(Map<String, String> languageMappings) {
        this.languageMappings = languageMappings;
    }

    @Override
    public Map<String, MediaType> getMediaTypeMappings() {
        return this.mediaTypeMappings;
    }

    @Override
    public Map<String, String> getLanguageMappings() {
        return this.languageMappings;
    }

    protected void preprocess(HttpRequest in) {
        this.preprocessExtensions(in);
    }

    protected void preprocessExtensions(HttpRequest in) {
        List segments = null;
        if (this.mediaTypeMappings != null || this.languageMappings != null) {
            int index;
            String path = in.getUri().getPath(false);
            int lastSegment = path.lastIndexOf(47);
            if (lastSegment < 0) {
                lastSegment = 0;
            }
            if ((index = path.indexOf(46, lastSegment)) < 0) {
                return;
            }
            boolean preprocessed = false;
            String extension = path.substring(index + 1);
            String[] extensions = extension.split("\\.");
            String rebuilt = path.substring(0, index);
            for (String ext : extensions) {
                Object match;
                if (this.mediaTypeMappings != null && (match = this.mediaTypeMappings.get(ext)) != null) {
                    in.getHttpHeaders().getAcceptableMediaTypes().add(match);
                    preprocessed = true;
                    continue;
                }
                if (this.languageMappings != null && (match = this.languageMappings.get(ext)) != null) {
                    in.getHttpHeaders().getAcceptableLanguages().add(LocaleHelper.extractLocale((String)match));
                    preprocessed = true;
                    continue;
                }
                rebuilt = rebuilt + "." + ext;
            }
            segments = preprocessed ? PathSegmentImpl.parseSegments(rebuilt) : in.getUri().getPathSegments(false);
        } else {
            segments = in.getUri().getPathSegments(false);
        }
        StringBuffer preprocessedPath = new StringBuffer();
        for (PathSegment pathSegment : segments) {
            preprocessedPath.append("/").append(pathSegment.getPath());
        }
        in.setPreprocessedPath(preprocessedPath.toString());
    }

    @Override
    public void invoke(HttpRequest in, HttpResponse response) {
        logger.debug("PathInfo: " + in.getUri().getPath());
        this.preprocess(in);
        ResourceInvoker invoker = null;
        try {
            invoker = this.registry.getResourceInvoker(in, response);
        }
        catch (Failure e) {
            this.handleFailure(in, response, e);
            logger.info(e.getMessage());
            return;
        }
        if (invoker == null) {
            try {
                response.sendError(404);
            }
            catch (Exception e) {
                throw new UnhandledException(e);
            }
            logger.info("Could not match path: " + in.getUri().getPath());
            return;
        }
        this.invoke(in, response, invoker);
    }

    public void handleInvokerException(HttpRequest request, HttpResponse response, Exception e) {
        this.handleException(request, response, e);
    }

    public void handleWriteResponseException(HttpRequest request, HttpResponse response, Exception e) {
        this.handleException(request, response, e);
    }

    protected void handleException(HttpRequest request, HttpResponse response, Exception e) {
        if (e instanceof WebApplicationException) {
            this.handleWebApplicationException(response, (WebApplicationException)((Object)e));
        } else if (e instanceof ApplicationException) {
            this.handleApplicationException(response, (ApplicationException)e);
        } else if (e instanceof Failure) {
            this.handleFailure(request, response, e);
        } else {
            logger.error("Unknown exception while executing " + request.getHttpMethod() + " " + request.getUri().getPath(), (Throwable)e);
            throw new UnhandledException(e);
        }
    }

    protected void handleFailure(HttpRequest request, HttpResponse response, Exception e) {
        Failure failure = (Failure)e;
        if (failure.getResponse() != null) {
            try {
                this.writeJaxrsResponse(response, failure.getResponse());
            }
            catch (Exception e1) {
                throw new UnhandledException(e1);
            }
        }
        try {
            if (failure.getMessage() != null) {
                response.sendError(failure.getErrorCode(), failure.getMessage());
            } else {
                response.sendError(failure.getErrorCode());
            }
        }
        catch (IOException e1) {
            throw new UnhandledException(e1);
        }
        if (((Failure)e).isLoggable()) {
            logger.error("Failed executing " + request.getHttpMethod() + " " + request.getUri().getPath(), (Throwable)e);
        } else {
            logger.debug("Failed executing " + request.getHttpMethod() + " " + request.getUri().getPath(), (Throwable)e);
        }
    }

    protected void handleApplicationException(HttpResponse response, ApplicationException e) {
        if (e.getCause() instanceof WebApplicationException) {
            this.handleWebApplicationException(response, (WebApplicationException)e.getCause());
            return;
        }
        ExceptionMapper<?> mapper = null;
        Class<?> causeClass = e.getCause().getClass();
        while (mapper == null && causeClass != null) {
            mapper = this.providerFactory.getExceptionMapper(causeClass);
            if (mapper != null) continue;
            causeClass = causeClass.getSuperclass();
        }
        if (mapper != null) {
            try {
                this.writeJaxrsResponse(response, mapper.toResponse(e.getCause()));
            }
            catch (WebApplicationException ex) {
                if (response.isCommitted()) {
                    throw new UnhandledException("Request was committed couldn't handle exception", ex);
                }
                response.reset();
                response.setStatus(ex.getResponse().getStatus());
            }
            catch (Exception e1) {
                throw new UnhandledException(e1);
            }
        } else {
            throw new UnhandledException(e.getCause());
        }
    }

    protected void handleWebApplicationException(HttpResponse response, WebApplicationException wae) {
        if (response.isCommitted()) {
            throw new UnhandledException("Request was committed couldn't handle exception", wae);
        }
        response.reset();
        try {
            this.writeJaxrsResponse(response, wae.getResponse());
        }
        catch (WebApplicationException ex) {
            if (response.isCommitted()) {
                throw new UnhandledException("Request was committed couldn't handle exception", ex);
            }
            response.reset();
            response.setStatus(ex.getResponse().getStatus());
        }
        catch (Exception e1) {
            throw new UnhandledException(e1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(HttpRequest request, HttpResponse response, ResourceInvoker invoker) {
        try {
            ResteasyProviderFactory.pushContext(HttpRequest.class, request);
            ResteasyProviderFactory.pushContext(HttpResponse.class, response);
            ResteasyProviderFactory.pushContext(HttpHeaders.class, request.getHttpHeaders());
            ResteasyProviderFactory.pushContext(UriInfo.class, request.getUri());
            ResteasyProviderFactory.pushContext(Request.class, new RequestImpl(request));
            ResteasyProviderFactory.pushContext(Providers.class, (Object)this.providerFactory);
            Response jaxrsResponse = null;
            try {
                jaxrsResponse = invoker.invoke(request, response);
            }
            catch (Exception e) {
                this.handleInvokerException(request, response, e);
            }
            try {
                if (jaxrsResponse != null) {
                    this.writeJaxrsResponse(response, jaxrsResponse);
                }
            }
            catch (Exception e) {
                this.handleWriteResponseException(request, response, e);
            }
        }
        finally {
            ResteasyProviderFactory.clearContextData();
        }
    }

    protected void writeJaxrsResponse(HttpResponse response, Response jaxrsResponse) throws IOException, WebApplicationException {
        List cookies;
        if (jaxrsResponse.getMetadata() != null && (cookies = (List)jaxrsResponse.getMetadata().get((Object)"Set-Cookie")) != null) {
            Iterator it = cookies.iterator();
            while (it.hasNext()) {
                Object next = it.next();
                if (!(next instanceof NewCookie)) continue;
                NewCookie cookie = (NewCookie)next;
                response.addNewCookie(cookie);
                it.remove();
            }
            if (cookies.size() < 1) {
                jaxrsResponse.getMetadata().remove((Object)"Set-Cookie");
            }
        }
        if (jaxrsResponse.getEntity() == null) {
            response.setStatus(jaxrsResponse.getStatus());
            this.outputHeaders(response, jaxrsResponse);
        }
        if (jaxrsResponse.getEntity() != null) {
            MessageBodyWriter<?> writer;
            MediaType responseContentType = this.resolveContentType(jaxrsResponse);
            Object entity = jaxrsResponse.getEntity();
            Class<?> type = jaxrsResponse.getEntity().getClass();
            Type genericType = null;
            Annotation[] annotations = null;
            if (entity instanceof GenericEntity) {
                GenericEntity ge = (GenericEntity)entity;
                genericType = ge.getType();
                entity = ge.getEntity();
                type = entity.getClass();
            }
            if (jaxrsResponse instanceof ResponseImpl) {
                if (genericType == null) {
                    genericType = ((ResponseImpl)jaxrsResponse).getGenericType();
                }
                annotations = ((ResponseImpl)jaxrsResponse).getAnnotations();
            }
            if ((writer = this.providerFactory.getMessageBodyWriter(type, genericType, annotations, responseContentType)) == null) {
                throw new LoggableFailure("Could not find MessageBodyWriter for response object of type: " + type.getName() + " of media type: " + responseContentType, 500);
            }
            long size = writer.getSize(entity, type, genericType, annotations, responseContentType);
            response.setStatus(jaxrsResponse.getStatus());
            this.outputHeaders(response, jaxrsResponse);
            response.getOutputHeaders().putSingle((Object)"Content-Length", (Object)Integer.toString((int)size));
            writer.writeTo(entity, type, genericType, annotations, responseContentType, response.getOutputHeaders(), response.getOutputStream());
        }
    }

    protected MediaType resolveContentType(Response jaxrsResponse) {
        MediaType responseContentType = null;
        Object type = jaxrsResponse.getMetadata().getFirst((Object)"Content-Type");
        if (type == null) {
            return MediaType.valueOf((String)"*/*");
        }
        responseContentType = type instanceof MediaType ? (MediaType)type : MediaType.valueOf((String)type.toString());
        return responseContentType;
    }

    protected void outputHeaders(HttpResponse response, Response jaxrsResponse) {
        if (jaxrsResponse.getMetadata() != null && jaxrsResponse.getMetadata().size() > 0) {
            response.getOutputHeaders().putAll((Map)jaxrsResponse.getMetadata());
        }
    }
}

