/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.plugins.providers.AbstractEntityProvider;
import org.jboss.resteasy.plugins.providers.ProviderHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"multipart/mixed"})
@Consumes(value={"multipart/mixed", "multipart/form-data"})
public class MimeMultipartProvider
extends AbstractEntityProvider<MimeMultipart> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MimeMultipart.class.equals(type);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MimeMultipart.class.equals(type);
    }

    public MimeMultipart readFrom(Class<MimeMultipart> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            DataSource ds = ProviderHelper.readDataSource(entityStream, mediaType);
            return new MimeMultipart(ds);
        }
        catch (MessagingException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    public void writeTo(MimeMultipart mimeMultipart, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            httpHeaders.putSingle((Object)"Content-Type", (Object)MediaType.valueOf((String)mimeMultipart.getContentType()));
            mimeMultipart.writeTo(entityStream);
        }
        catch (MessagingException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }
}

