/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jaxb;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jboss.resteasy.core.ExceptionAdapter;
import org.jboss.resteasy.plugins.providers.jaxb.AbstractJAXBProvider;
import org.jboss.resteasy.spi.LoggableFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"text/*+xml", "application/*+xml"})
@Consumes(value={"text/*+xml", "application/*+xml"})
public class JAXBXmlTypeProvider
extends AbstractJAXBProvider<Object> {
    protected static final String OBJECT_FACTORY_NAME = ".ObjectFactory";

    @Override
    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        JAXBElement<?> result = this.wrapInJAXBElement(t, type);
        super.writeTo(result, type, genericType, annotations, mediaType, httpHeaders, entityStream);
    }

    @Override
    protected boolean isReadWritable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return !type.isAnnotationPresent(XmlRootElement.class) && type.isAnnotationPresent(XmlType.class);
    }

    private Object findObjectFactory(Object t, Class<?> type) {
        try {
            StringBuilder b = new StringBuilder(type.getPackage().getName());
            b.append(OBJECT_FACTORY_NAME);
            Class<?> factoryClass = Thread.currentThread().getContextClassLoader().loadClass(b.toString());
            if (factoryClass.isAnnotationPresent(XmlRegistry.class)) {
                Object factory = factoryClass.newInstance();
                return factory;
            }
            throw new LoggableFailure("A valid XmlRegistry could not be located.");
        }
        catch (ClassNotFoundException e) {
            throw new ExceptionAdapter(e);
        }
        catch (InstantiationException e) {
            throw new ExceptionAdapter(e);
        }
        catch (IllegalAccessException e) {
            throw new ExceptionAdapter(e);
        }
    }

    protected JAXBElement<?> wrapInJAXBElement(Object t, Class<?> type) {
        try {
            Object factory = this.findObjectFactory(t, type);
            Method[] method = factory.getClass().getDeclaredMethods();
            for (int i = 0; i < method.length; ++i) {
                Method current = method[i];
                if (current.getParameterTypes().length != 1 || !current.getParameterTypes()[0].equals(type) || !current.getName().startsWith("create")) continue;
                Object result = current.invoke(factory, t);
                return (JAXBElement)JAXBElement.class.cast(result);
            }
            throw new LoggableFailure(String.format("The method create%s() was not found in the object Factory!", type));
        }
        catch (IllegalArgumentException e) {
            throw new ExceptionAdapter(e);
        }
        catch (IllegalAccessException e) {
            throw new ExceptionAdapter(e);
        }
        catch (InvocationTargetException e) {
            throw new ExceptionAdapter(e);
        }
    }
}

