/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jaxb.json;

import java.lang.annotation.Annotation;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.jboss.resteasy.annotations.providers.jaxb.json.BadgerFish;
import org.jboss.resteasy.annotations.providers.jaxb.json.Mapped;
import org.jboss.resteasy.plugins.providers.jaxb.AbstractJAXBProvider;
import org.jboss.resteasy.plugins.providers.jaxb.json.BadgerContext;
import org.jboss.resteasy.plugins.providers.jaxb.json.JettisonMappedContext;
import org.jboss.resteasy.util.FindAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettisonJAXBContextFactory {
    private ConcurrentHashMap<Class<?>, JAXBContext> mappedCache = new ConcurrentHashMap();
    private ConcurrentHashMap<Class<?>, JAXBContext> badgerCache = new ConcurrentHashMap();
    private AbstractJAXBProvider provider;

    public JettisonJAXBContextFactory(AbstractJAXBProvider provider) {
        this.provider = provider;
    }

    public JAXBContext findJAXBContext(Class<?> type, Annotation[] annotations, MediaType mediaType) throws JAXBException {
        Mapped mapped = FindAnnotation.findAnnotation(type, annotations, Mapped.class);
        BadgerFish badger = FindAnnotation.findAnnotation(type, annotations, BadgerFish.class);
        if (badger != null) {
            return this.find(type, mediaType, this.badgerCache, mapped, badger);
        }
        return this.find(type, mediaType, this.mappedCache, mapped, badger);
    }

    protected JAXBContext find(Class<?> type, MediaType mediaType, ConcurrentHashMap<Class<?>, JAXBContext> cache, Mapped mapped, BadgerFish badger) throws JAXBException {
        JAXBContext jaxb = cache.get(type);
        if (jaxb != null) {
            return jaxb;
        }
        jaxb = this.provider.findProvidedJAXBContext(type, mediaType);
        if (jaxb == null) {
            jaxb = badger != null ? new BadgerContext(type) : (mapped != null ? new JettisonMappedContext(mapped, type) : new JettisonMappedContext(type));
        }
        cache.putIfAbsent(type, jaxb);
        return jaxb;
    }
}

