/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.server.servlet.HttpServletInputMessage;
import org.jboss.resteasy.plugins.server.servlet.HttpServletResponseWrapper;
import org.jboss.resteasy.plugins.server.servlet.ServletSecurityContext;
import org.jboss.resteasy.plugins.server.servlet.ServletUtil;
import org.jboss.resteasy.specimpl.UriInfoImpl;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServletDispatcher
extends HttpServlet {
    protected Dispatcher dispatcher;
    private static final Logger logger = LoggerFactory.getLogger(HttpServletDispatcher.class);
    private String servletMappingPrefix = "";

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        ResteasyProviderFactory providerFactory = (ResteasyProviderFactory)((Object)servletConfig.getServletContext().getAttribute(ResteasyProviderFactory.class.getName()));
        if (providerFactory == null) {
            providerFactory = new ResteasyProviderFactory();
            servletConfig.getServletContext().setAttribute(ResteasyProviderFactory.class.getName(), (Object)providerFactory);
        }
        this.dispatcher = (Dispatcher)servletConfig.getServletContext().getAttribute(Dispatcher.class.getName());
        if (this.dispatcher == null) {
            this.dispatcher = new SynchronousDispatcher(providerFactory);
            servletConfig.getServletContext().setAttribute(Dispatcher.class.getName(), (Object)this.dispatcher);
            servletConfig.getServletContext().setAttribute(Registry.class.getName(), (Object)this.dispatcher.getRegistry());
        }
    }

    public void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.service(httpServletRequest.getMethod(), httpServletRequest, httpServletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(String httpMethod, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpServletInputMessage in;
        HttpHeaders headers = ServletUtil.extractHttpHeaders(request);
        UriInfoImpl uriInfo = ServletUtil.extractUriInfo(request);
        try {
            in = new HttpServletInputMessage(headers, (InputStream)request.getInputStream(), uriInfo, httpMethod.toUpperCase());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        HttpServletResponseWrapper theResponse = new HttpServletResponseWrapper(response, this.dispatcher.getProviderFactory());
        try {
            ResteasyProviderFactory.pushContext(HttpServletRequest.class, request);
            ResteasyProviderFactory.pushContext(HttpServletResponse.class, response);
            ResteasyProviderFactory.pushContext(SecurityContext.class, new ServletSecurityContext(request));
            this.dispatcher.invoke(in, theResponse);
        }
        finally {
            ResteasyProviderFactory.clearContextData();
        }
    }
}

