/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import javax.servlet.ServletContext;
import org.jboss.resteasy.plugins.server.servlet.SpringBeanProcessor;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.ContextLoader;

public class SpringContextLoader
extends ContextLoader {
    protected void customizeContext(ServletContext servletContext, ConfigurableWebApplicationContext configurableWebApplicationContext) {
        super.customizeContext(servletContext, configurableWebApplicationContext);
        final ResteasyProviderFactory providerFactory = (ResteasyProviderFactory)((Object)servletContext.getAttribute(ResteasyProviderFactory.class.getName()));
        if (providerFactory == null) {
            throw new RuntimeException("RESTeasy Provider Factory is null, do you have the ResteasyBootstrap listener configured?");
        }
        final Registry registry = (Registry)servletContext.getAttribute(Registry.class.getName());
        if (registry == null) {
            throw new RuntimeException("RESTeasy Registry is null, do ou have the ResteasyBootstrap listener configured?");
        }
        BeanFactoryPostProcessor processor = new BeanFactoryPostProcessor(){

            public void postProcessBeanFactory(ConfigurableListableBeanFactory factory) throws BeansException {
                factory.addBeanPostProcessor((BeanPostProcessor)new SpringBeanProcessor(registry, providerFactory));
            }
        };
        configurableWebApplicationContext.addBeanFactoryPostProcessor(processor);
    }
}

