/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.core;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URI;
import javax.ws.rs.CookieParam;
import javax.ws.rs.Encoded;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.jboss.resteasy.annotations.Form;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.ClientResponseFailure;
import org.jboss.resteasy.client.core.CookieParamMarshaller;
import org.jboss.resteasy.client.core.FormMarshaller;
import org.jboss.resteasy.client.core.FormParamMarshaller;
import org.jboss.resteasy.client.core.HeaderParamMarshaller;
import org.jboss.resteasy.client.core.Marshaller;
import org.jboss.resteasy.client.core.MatrixParamMarshaller;
import org.jboss.resteasy.client.core.MessageBodyParameterMarshaller;
import org.jboss.resteasy.client.core.PathParamMarshaller;
import org.jboss.resteasy.client.core.QueryParamMarshaller;
import org.jboss.resteasy.specimpl.UriBuilderImpl;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.CaseInsensitiveMap;
import org.jboss.resteasy.util.FindAnnotation;
import org.jboss.resteasy.util.MediaTypeHelper;
import org.jboss.resteasy.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClientInvoker {
    protected ResteasyProviderFactory providerFactory;
    protected Method method;
    protected Marshaller[] params;
    protected UriBuilderImpl builder;
    protected Class declaring;
    protected MediaType accepts;
    protected HttpClient client;

    public ClientInvoker(Class<?> declaring, Method method, ResteasyProviderFactory providerFactory, HttpClient client) {
        this.declaring = declaring;
        this.method = method;
        this.providerFactory = providerFactory;
        this.params = new Marshaller[method.getParameterTypes().length];
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            Marshaller marshaller;
            Class<?> type = method.getParameterTypes()[i];
            Annotation[] annotations = method.getParameterAnnotations()[i];
            Type genericType = method.getGenericParameterTypes()[i];
            Method target = method;
            this.params[i] = marshaller = ClientInvoker.createMarshaller(declaring, providerFactory, type, annotations, genericType, target, false);
        }
        this.accepts = MediaTypeHelper.getProduces(declaring, method);
        this.client = client;
    }

    public static Marshaller createMarshaller(Class<?> declaring, ResteasyProviderFactory providerFactory, Class type, Annotation[] annotations, Type genericType, AccessibleObject target, boolean ignoreBody) {
        Marshaller marshaller = null;
        boolean isEncoded = FindAnnotation.findAnnotation(annotations, Encoded.class) != null;
        QueryParam query = FindAnnotation.findAnnotation(annotations, QueryParam.class);
        if (query != null) {
            marshaller = new QueryParamMarshaller(query.value());
        } else {
            HeaderParam header = FindAnnotation.findAnnotation(annotations, HeaderParam.class);
            if (header != null) {
                marshaller = new HeaderParamMarshaller(header.value());
            } else {
                CookieParam cookie = FindAnnotation.findAnnotation(annotations, CookieParam.class);
                if (cookie != null) {
                    marshaller = new CookieParamMarshaller(cookie.value());
                } else {
                    PathParam uriParam = FindAnnotation.findAnnotation(annotations, PathParam.class);
                    if (uriParam != null) {
                        marshaller = new PathParamMarshaller(uriParam.value(), isEncoded);
                    } else {
                        MatrixParam matrix = FindAnnotation.findAnnotation(annotations, MatrixParam.class);
                        if (matrix != null) {
                            marshaller = new MatrixParamMarshaller(matrix.value());
                        } else {
                            FormParam formParam = FindAnnotation.findAnnotation(annotations, FormParam.class);
                            if (formParam != null) {
                                marshaller = new FormParamMarshaller(formParam.value());
                            } else {
                                Form form = FindAnnotation.findAnnotation(annotations, Form.class);
                                if (form != null) {
                                    marshaller = new FormMarshaller(type, providerFactory);
                                } else if (type.equals(Cookie.class)) {
                                    marshaller = new CookieParamMarshaller(null);
                                } else if (!ignoreBody) {
                                    MediaType mediaType = MediaTypeHelper.getConsumes(declaring, target);
                                    if (mediaType == null) {
                                        throw new RuntimeException("You must define a @ConsumeMime type on your client method or interface");
                                    }
                                    marshaller = new MessageBodyParameterMarshaller(mediaType, type, genericType, annotations, providerFactory);
                                }
                            }
                        }
                    }
                }
            }
        }
        return marshaller;
    }

    public void setBaseUri(URI uri) {
        this.builder = new UriBuilderImpl();
        this.builder.uri(uri);
        this.builder.path(this.declaring);
        this.builder.path(this.method);
    }

    protected void checkFailureStatus(HttpMethodBase baseMethod, int status) {
        if (status > 399 && status < 599) {
            throw new ClientResponseFailure("Error status " + status + " " + Response.Status.fromStatusCode((int)status) + " returned", this.createGenericClientResponse(baseMethod, status));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object[] args) {
        boolean isProvidersSet;
        boolean bl = isProvidersSet = ResteasyProviderFactory.getContextData(Providers.class) != null;
        if (!isProvidersSet) {
            ResteasyProviderFactory.pushContext(Providers.class, (Object)this.providerFactory);
        }
        try {
            int status;
            HttpMethodBase baseMethod;
            block32: {
                block30: {
                    ClientResponse clientResponse;
                    Class<?> returnType;
                    Type genericReturnType;
                    block31: {
                        block29: {
                            Response.Status e3;
                            if (this.builder == null) {
                                throw new RuntimeException("You have not set a base URI for the client proxy");
                            }
                            UriBuilderImpl uri = (UriBuilderImpl)this.builder.clone();
                            if (args != null) {
                                for (int i = 0; i < args.length; ++i) {
                                    this.params[i].buildUri(args[i], uri);
                                }
                            }
                            String url = null;
                            baseMethod = null;
                            try {
                                url = uri.build(new Object[0]).toURL().toString();
                                baseMethod = this.createBaseMethod(url);
                                if (ClientResponse.class.isAssignableFrom(this.method.getReturnType())) {
                                    baseMethod.setFollowRedirects(false);
                                }
                            }
                            catch (MalformedURLException e2) {
                                throw new RuntimeException("Unable to build URL from uri", e2);
                            }
                            if (this.accepts != null) {
                                baseMethod.setRequestHeader("Accept", this.accepts.toString());
                            }
                            if (args != null) {
                                int i;
                                for (i = 0; i < args.length; ++i) {
                                    this.params[i].setHeaders(args[i], baseMethod);
                                }
                                for (i = 0; i < args.length; ++i) {
                                    this.params[i].buildRequest(args[i], baseMethod);
                                }
                            }
                            status = 0;
                            try {
                                status = this.client.executeMethod((HttpMethod)baseMethod);
                            }
                            catch (IOException e3) {
                                throw new RuntimeException("Failed to execute GET request: " + url, e3);
                            }
                            try {
                                if (!this.method.getReturnType().equals(Response.Status.class)) break block29;
                                e3 = Response.Status.fromStatusCode((int)status);
                            }
                            catch (Throwable throwable) {
                                baseMethod.releaseConnection();
                                throw throwable;
                            }
                            baseMethod.releaseConnection();
                            return e3;
                        }
                        if (!ClientResponse.class.isAssignableFrom(this.method.getReturnType())) break block30;
                        genericReturnType = null;
                        returnType = null;
                        if (this.method.getGenericReturnType() instanceof ParameterizedType) {
                            ParameterizedType zType = (ParameterizedType)this.method.getGenericReturnType();
                            genericReturnType = zType.getActualTypeArguments()[0];
                            returnType = Types.getRawType(genericReturnType);
                        }
                        if (returnType != null) break block31;
                        clientResponse = this.createGenericClientResponse(baseMethod, status);
                        baseMethod.releaseConnection();
                        return clientResponse;
                    }
                    this.checkFailureStatus(baseMethod, status);
                    clientResponse = this.extractClientResponse(baseMethod, status, genericReturnType, returnType);
                    baseMethod.releaseConnection();
                    return clientResponse;
                }
                if (this.method.getReturnType() == null || this.method.getReturnType().equals(Void.TYPE)) break block32;
                this.checkFailureStatus(baseMethod, status);
                Object t = this.extractClientResponse(baseMethod, status, this.method.getGenericReturnType(), this.method.getReturnType()).getEntity();
                baseMethod.releaseConnection();
                return t;
            }
            this.checkFailureStatus(baseMethod, status);
            Object var7_13 = null;
            baseMethod.releaseConnection();
            return var7_13;
        }
        finally {
            if (!isProvidersSet) {
                ResteasyProviderFactory.popContextData(Providers.class);
            }
        }
    }

    public abstract HttpMethodBase createBaseMethod(String var1);

    protected ClientResponse<byte[]> createGenericClientResponse(final HttpMethodBase baseMethod, final int status) {
        final CaseInsensitiveMap<String> headers = new CaseInsensitiveMap<String>();
        for (Header header : baseMethod.getResponseHeaders()) {
            headers.add(header.getName(), header.getValue());
        }
        return new ClientResponse<byte[]>(){

            @Override
            public byte[] getEntity() {
                try {
                    return baseMethod.getResponseBody();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public MultivaluedMap<String, String> getHeaders() {
                return headers;
            }

            @Override
            public int getStatus() {
                return status;
            }
        };
    }

    protected ClientResponse extractClientResponse(HttpMethodBase baseMethod, final int status, Type genericReturnType, Class returnType) {
        final CaseInsensitiveMap<String> headers = new CaseInsensitiveMap<String>();
        for (Header header : baseMethod.getResponseHeaders()) {
            headers.add(header.getName(), header.getValue());
        }
        Header contentType = baseMethod.getResponseHeader("Content-Type");
        if (contentType == null) {
            ClientResponse<byte[]> response = this.createGenericClientResponse(baseMethod, status);
            throw new ClientResponseFailure("No Content-Type header specified", response);
        }
        String mediaType = baseMethod.getResponseHeader("Content-Type").getValue();
        if (mediaType == null) {
            Produces produce = this.method.getAnnotation(Produces.class);
            if (produce == null) {
                produce = this.declaring.getAnnotation(Produces.class);
            }
            if (produce == null) {
                ClientResponse<byte[]> response = this.createGenericClientResponse(baseMethod, status);
                throw new ClientResponseFailure("@Produces on your proxy method, " + this.method.toString() + ", is required", response);
            }
            mediaType = produce.value()[0];
        }
        if (returnType == null) {
            returnType = byte[].class;
        }
        MediaType media = MediaType.valueOf((String)mediaType);
        MessageBodyReader<byte[]> reader = this.providerFactory.getMessageBodyReader(returnType, genericReturnType, this.method.getAnnotations(), media);
        if (reader == null) {
            ClientResponse<byte[]> response = this.createGenericClientResponse(baseMethod, status);
            throw new ClientResponseFailure("Unable to find a MessageBodyReader of content-type " + mediaType + " for response of " + this.method.toString(), response);
        }
        try {
            final Object response = reader.readFrom(returnType, genericReturnType, this.method.getAnnotations(), media, headers, baseMethod.getResponseBodyAsStream());
            return new ClientResponse(){

                public Object getEntity() {
                    return response;
                }

                public MultivaluedMap getHeaders() {
                    return headers;
                }

                public int getStatus() {
                    return status;
                }
            };
        }
        catch (IOException e) {
            return new ClientResponse(){

                public Object getEntity() {
                    throw new RuntimeException("Unable to unmarshall response for " + ClientInvoker.this.method.toString(), e);
                }

                public MultivaluedMap getHeaders() {
                    return headers;
                }

                public int getStatus() {
                    return status;
                }
            };
        }
    }
}

