/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.annotations.Form;
import org.jboss.resteasy.core.ConstructorInjectorImpl;
import org.jboss.resteasy.core.ContextParameterInjector;
import org.jboss.resteasy.core.CookieParamInjector;
import org.jboss.resteasy.core.FormInjector;
import org.jboss.resteasy.core.FormParamInjector;
import org.jboss.resteasy.core.HeaderParamInjector;
import org.jboss.resteasy.core.MatrixParamInjector;
import org.jboss.resteasy.core.MessageBodyParameterInjector;
import org.jboss.resteasy.core.MethodInjectorImpl;
import org.jboss.resteasy.core.PathParamInjector;
import org.jboss.resteasy.core.PropertyInjectorImpl;
import org.jboss.resteasy.core.QueryParamInjector;
import org.jboss.resteasy.core.ValueInjector;
import org.jboss.resteasy.spi.ConstructorInjector;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.MethodInjector;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.FindAnnotation;

public class InjectorFactoryImpl
implements InjectorFactory {
    private ResteasyProviderFactory factory;

    public InjectorFactoryImpl(ResteasyProviderFactory factory) {
        this.factory = factory;
    }

    public ConstructorInjector createConstructor(Constructor constructor) {
        return new ConstructorInjectorImpl(constructor, this.factory);
    }

    public PropertyInjector createPropertyInjector(Class resourceClass) {
        return new PropertyInjectorImpl(resourceClass, this.factory);
    }

    public MethodInjector createMethodInjector(Method method) {
        return new MethodInjectorImpl(method, this.factory);
    }

    public static ValueInjector getParameterExtractor(Class type, Type genericType, Annotation[] annotations, AccessibleObject target, ResteasyProviderFactory providerFactory) {
        QueryParam query;
        DefaultValue defaultValue = FindAnnotation.findAnnotation(annotations, DefaultValue.class);
        boolean encode = FindAnnotation.findAnnotation(annotations, Encoded.class) != null || target.isAnnotationPresent(Encoded.class) || type.isAnnotationPresent(Encoded.class);
        String defaultVal = null;
        if (defaultValue != null) {
            defaultVal = defaultValue.value();
        }
        if ((query = FindAnnotation.findAnnotation(annotations, QueryParam.class)) != null) {
            return new QueryParamInjector(type, genericType, target, query.value(), defaultVal, encode);
        }
        HeaderParam header = FindAnnotation.findAnnotation(annotations, HeaderParam.class);
        if (header != null) {
            return new HeaderParamInjector(type, genericType, target, header.value(), defaultVal);
        }
        FormParam formParam = FindAnnotation.findAnnotation(annotations, FormParam.class);
        if (formParam != null) {
            return new FormParamInjector(type, genericType, target, formParam.value(), defaultVal);
        }
        CookieParam cookie = FindAnnotation.findAnnotation(annotations, CookieParam.class);
        if (cookie != null) {
            return new CookieParamInjector(type, genericType, target, cookie.value(), defaultVal);
        }
        PathParam uriParam = FindAnnotation.findAnnotation(annotations, PathParam.class);
        if (uriParam != null) {
            return new PathParamInjector(type, genericType, target, uriParam.value(), defaultVal, encode);
        }
        Form form = FindAnnotation.findAnnotation(annotations, Form.class);
        if (form != null) {
            return new FormInjector(type, providerFactory);
        }
        MatrixParam matrix = FindAnnotation.findAnnotation(annotations, MatrixParam.class);
        if (matrix != null) {
            return new MatrixParamInjector(type, genericType, target, matrix.value(), defaultVal);
        }
        if (FindAnnotation.findAnnotation(annotations, Context.class) != null) {
            return new ContextParameterInjector(type, providerFactory);
        }
        return new MessageBodyParameterInjector(type, genericType, annotations, providerFactory);
    }
}

