/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import org.jboss.resteasy.core.InjectorFactoryImpl;
import org.jboss.resteasy.core.ValueInjector;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.LoggableFailure;
import org.jboss.resteasy.spi.MethodInjector;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class MethodInjectorImpl
implements MethodInjector {
    protected Method method;
    protected ValueInjector[] params;
    protected ResteasyProviderFactory factory;

    public MethodInjectorImpl(Method method, ResteasyProviderFactory factory) {
        this.method = method;
        this.factory = factory;
        this.params = new ValueInjector[method.getParameterTypes().length];
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            Class<?> type = method.getParameterTypes()[i];
            Type genericType = method.getGenericParameterTypes()[i];
            Annotation[] annotations = method.getParameterAnnotations()[i];
            this.params[i] = InjectorFactoryImpl.getParameterExtractor(type, genericType, annotations, method, factory);
        }
    }

    public Object[] injectArguments(HttpRequest input, HttpResponse response) {
        try {
            Object[] args = null;
            if (this.params != null && this.params.length > 0) {
                args = new Object[this.params.length];
                int i = 0;
                for (ValueInjector extractor : this.params) {
                    args[i++] = extractor.inject(input, response);
                }
            }
            return args;
        }
        catch (WebApplicationException we) {
            throw we;
        }
        catch (Failure f) {
            throw f;
        }
        catch (Exception e) {
            throw new LoggableFailure("Failed processing arguments of " + this.method.toString(), (Throwable)e, 400);
        }
    }

    public Object invoke(HttpRequest request, HttpResponse httpResponse, Object resource) throws Failure, ApplicationException, WebApplicationException {
        Object[] args = this.injectArguments(request, httpResponse);
        try {
            return this.method.invoke(resource, args);
        }
        catch (IllegalAccessException e) {
            throw new LoggableFailure("Not allowed to reflect on method: " + this.method.toString(), (Throwable)e, 500);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof WebApplicationException) {
                WebApplicationException wae = (WebApplicationException)cause;
                throw wae;
            }
            throw new ApplicationException(cause);
        }
        catch (IllegalArgumentException e) {
            String msg = "Bad arguments passed to " + this.method.toString() + "  (";
            boolean first = false;
            for (Object arg : args) {
                if (!first) {
                    first = true;
                } else {
                    msg = msg + ",";
                }
                msg = arg == null ? msg + " null" : msg + " " + arg.getClass().getName() + " " + arg;
            }
            msg = msg + " )";
            throw new LoggableFailure(msg, (Throwable)e, 400);
        }
    }
}

