/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.grizzly;

import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.PathSegment;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.server.grizzly.GrizzlyHttpRequest;
import org.jboss.resteasy.plugins.server.grizzly.GrizzlyHttpResponse;
import org.jboss.resteasy.plugins.server.grizzly.GrizzlyUtils;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.specimpl.PathSegmentImpl;
import org.jboss.resteasy.specimpl.UriInfoImpl;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public abstract class AbstractGrizzlyDispatcher {
    protected Dispatcher dispatcher;
    protected String contextPath;

    public AbstractGrizzlyDispatcher(ResteasyProviderFactory providerFactory, String contextPath) {
        this.contextPath = contextPath;
        this.dispatcher = new SynchronousDispatcher(providerFactory);
        if (contextPath == null) {
            throw new RuntimeException("contextPath cannot be null");
        }
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    protected String getPathInfo(GrizzlyRequest request) {
        String requestURIString = request.getRequestURI();
        URI requestURI = URI.create(requestURIString);
        String path = requestURI.getPath();
        if (this.contextPath.equals("/")) {
            return path;
        }
        if (path.startsWith(this.contextPath)) {
            path = path.substring(this.contextPath.length());
            return path;
        }
        throw new IllegalStateException("Request path not in servlet context. path: " + path + " contextPath: " + this.contextPath);
    }

    protected StringBuffer getRequestURL(GrizzlyRequest request) {
        int port;
        StringBuffer url = new StringBuffer();
        String scheme = request.getScheme();
        if (scheme == null) {
            scheme = "http";
        }
        if ((port = request.getServerPort()) < 0) {
            port = 80;
        }
        url.append(scheme);
        url.append("://");
        url.append(request.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        url.append(request.getRequestURI());
        return url;
    }

    protected void invokeJaxrs(GrizzlyRequest request, GrizzlyResponse response) throws IOException {
        GrizzlyHttpRequest in;
        HttpHeaders headers = GrizzlyUtils.extractHttpHeaders(request);
        MultivaluedMapImpl<String, String> parameters = GrizzlyUtils.extractParameters(request);
        String path = this.getPathInfo(request);
        URI absolutePath = null;
        try {
            URL absolute = new URL(this.getRequestURL(request).toString());
            absolutePath = absolute.toURI();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        List<PathSegment> pathSegments = PathSegmentImpl.parseSegments(path);
        UriInfoImpl uriInfo = new UriInfoImpl(absolutePath, path, request.getQueryString(), pathSegments);
        try {
            in = new GrizzlyHttpRequest(headers, (InputStream)request.getInputStream(), uriInfo, request.getMethod().toUpperCase());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        HttpResponse theResponse = this.createHttpResponse(response);
        try {
            this.dispatcher.invoke(in, theResponse);
        }
        catch (Exception e) {
            response.sendError(500);
        }
    }

    protected HttpResponse createHttpResponse(GrizzlyResponse response) {
        GrizzlyHttpResponse theResponse = new GrizzlyHttpResponse(response, this.dispatcher.getProviderFactory());
        return theResponse;
    }
}

