/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.GetRestful;
import org.scannotation.AnnotationDB;
import org.scannotation.WarUrlFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResteasyBootstrap
implements ServletContextListener {
    private ResteasyProviderFactory factory = new ResteasyProviderFactory();
    private Registry registry;
    private Dispatcher dispatcher;

    public void contextInitialized(ServletContextEvent event) {
        String languageExtensions;
        String mimeExtentions;
        String resources;
        String jndiResources;
        String sResources;
        String scanAll;
        String builtin;
        String resourceMethodInterceptors;
        ResteasyProviderFactory.setInstance(this.factory);
        event.getServletContext().setAttribute(ResteasyProviderFactory.class.getName(), (Object)this.factory);
        this.dispatcher = new SynchronousDispatcher(this.factory);
        this.registry = this.dispatcher.getRegistry();
        event.getServletContext().setAttribute(Dispatcher.class.getName(), (Object)this.dispatcher);
        event.getServletContext().setAttribute(Registry.class.getName(), (Object)this.registry);
        String applicationConfig = event.getServletContext().getInitParameter(Application.class.getName());
        String providers = event.getServletContext().getInitParameter("resteasy.providers");
        if (providers != null) {
            this.setProviders(providers);
        }
        if ((resourceMethodInterceptors = event.getServletContext().getInitParameter("resteasy.resource.method.interceptors")) != null) {
            this.setProviders(resourceMethodInterceptors);
        }
        if ((builtin = event.getServletContext().getInitParameter("resteasy.use.builtin.providers")) == null || Boolean.valueOf(builtin.trim()).booleanValue()) {
            RegisterBuiltin.register(this.factory);
        }
        boolean scanProviders = false;
        boolean scanResources = false;
        String sProviders = event.getServletContext().getInitParameter("resteasy.scan.providers");
        if (sProviders != null) {
            scanProviders = Boolean.valueOf(sProviders.trim());
        }
        if ((scanAll = event.getServletContext().getInitParameter("resteasy.scan")) != null) {
            boolean tmp = Boolean.valueOf(scanAll.trim());
            scanProviders = tmp || scanProviders;
            boolean bl = scanResources = tmp || scanResources;
        }
        if ((sResources = event.getServletContext().getInitParameter("resteasy.scan.resources")) != null) {
            scanResources = Boolean.valueOf(sResources.trim());
        }
        if (scanProviders || scanResources) {
            if (applicationConfig != null) {
                throw new RuntimeException("You cannot deploy a javax.ws.rs.core.Application and have scanning on as this may create errors");
            }
            URL[] urls = WarUrlFinder.findWebInfLibClasspaths((ServletContextEvent)event);
            URL url = WarUrlFinder.findWebInfClassesPath((ServletContextEvent)event);
            AnnotationDB db = new AnnotationDB();
            String[] ignoredPackages = new String[]{"org.jboss.resteasy.plugins", "org.jboss.resteasy.annotations", "org.jboss.resteasy.client", "org.jboss.resteasy.specimpl", "org.jboss.resteasy.core", "org.jboss.resteasy.spi", "org.jboss.resteasy.util", "org.jboss.resteasy.mock", "javax.ws.rs"};
            db.setIgnoredPackages(ignoredPackages);
            try {
                if (url != null) {
                    db.scanArchives(new URL[]{url});
                }
                db.scanArchives(urls);
                try {
                    db.crossReferenceImplementedInterfaces();
                    db.crossReferenceMetaAnnotations();
                }
                catch (AnnotationDB.CrossReferenceException ignored) {}
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to scan WEB-INF for JAX-RS annotations, you must manually register your classes/resources", e);
            }
            if (scanProviders) {
                this.processProviders(db);
            }
            if (scanResources) {
                this.processResources(db);
            }
        }
        if ((jndiResources = event.getServletContext().getInitParameter("resteasy.jndi.resources")) != null) {
            this.processJndiResources(jndiResources);
        }
        if ((resources = event.getServletContext().getInitParameter("resteasy.resources")) != null) {
            this.processResources(resources);
        }
        if ((mimeExtentions = event.getServletContext().getInitParameter("resteasy.media.type.mappings")) != null) {
            Map<String, String> map = this.parseMap(mimeExtentions);
            HashMap<String, MediaType> extMap = new HashMap<String, MediaType>();
            for (String ext : map.keySet()) {
                String value = map.get(ext);
                extMap.put(ext, MediaType.valueOf((String)value));
            }
            if (this.dispatcher.getMediaTypeMappings() != null) {
                this.dispatcher.getMediaTypeMappings().putAll(extMap);
            } else {
                this.dispatcher.setMediaTypeMappings(extMap);
            }
        }
        if ((languageExtensions = event.getServletContext().getInitParameter("resteasy.language.mappings")) != null) {
            Map<String, String> map = this.parseMap(languageExtensions);
            if (this.dispatcher.getLanguageMappings() != null) {
                this.dispatcher.getLanguageMappings().putAll(map);
            } else {
                this.dispatcher.setLanguageMappings(map);
            }
        }
        if (applicationConfig != null) {
            try {
                Class<?> configClass = Thread.currentThread().getContextClassLoader().loadClass(applicationConfig.trim());
                Application config = (Application)configClass.newInstance();
                ResteasyBootstrap.processApplication(config, this.registry, this.factory);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void processApplication(Application config, Registry registry, ResteasyProviderFactory factory) {
        if (config.getClasses() != null) {
            for (Class clazz : config.getClasses()) {
                if (clazz.isAnnotationPresent(Path.class)) {
                    registry.addPerRequestResource(clazz);
                    continue;
                }
                factory.registerProvider(clazz);
            }
        }
        if (config.getSingletons() != null) {
            for (Object obj : config.getSingletons()) {
                if (obj.getClass().isAnnotationPresent(Path.class)) {
                    registry.addSingletonResource(obj);
                    continue;
                }
                factory.registerProviderInstance(obj);
            }
        }
    }

    protected Map<String, String> parseMap(String map) {
        String[] entries;
        HashMap<String, String> parsed = new HashMap<String, String>();
        for (String entry : entries = map.trim().split(",")) {
            String[] split = entry.trim().split(":");
            parsed.put(split[0].trim(), split[1].trim());
        }
        return parsed;
    }

    protected void processJndiResources(String jndiResources) {
        String[] resources;
        for (String resource : resources = jndiResources.trim().split(",")) {
            this.registry.addJndiResource(resource.trim());
        }
    }

    protected void processResources(String list) {
        String[] resources;
        for (String resource : resources = list.trim().split(",")) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(resource.trim());
                this.registry.addPerRequestResource(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void processProviders(AnnotationDB db) {
        Set classes = (Set)db.getAnnotationIndex().get(Provider.class.getName());
        if (classes == null) {
            return;
        }
        for (String clazz : classes) {
            this.registerProvider(clazz);
        }
    }

    private void registerProvider(String clazz) {
        Class<?> provider = null;
        try {
            provider = Thread.currentThread().getContextClassLoader().loadClass(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        System.out.println("FOUND JAX-RS @Provider: " + clazz);
        this.factory.registerProvider(provider);
    }

    protected void processResources(AnnotationDB db) {
        HashSet classes = new HashSet();
        Set paths = (Set)db.getAnnotationIndex().get(Path.class.getName());
        if (paths != null) {
            classes.addAll(paths);
        }
        for (String clazz : classes) {
            this.processResource(clazz);
        }
    }

    protected void processResource(String clazz) {
        Class<?> resource = null;
        try {
            resource = Thread.currentThread().getContextClassLoader().loadClass(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (resource.isInterface()) {
            return;
        }
        if (!GetRestful.isRootResource(resource)) {
            return;
        }
        System.out.println("FOUND JAX-RS resource: " + clazz);
        this.registry.addPerRequestResource(resource);
    }

    protected void setProviders(String providers) {
        String[] p;
        for (String provider : p = providers.split(",")) {
            provider = provider.trim();
            this.registerProvider(provider);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
    }
}

