/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import org.apache.commons.httpclient.HttpMethodBase;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.CaseInsensitiveMap;
import org.jboss.resteasy.util.GenericType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientResponseImpl
implements ClientResponse {
    protected ResteasyProviderFactory providerFactory;
    protected HttpMethodBase baseMethod;
    protected Class returnType;
    protected Type genericReturnType;
    protected Annotation[] annotations;
    protected CaseInsensitiveMap<String> headers;
    protected int status;
    protected boolean wasReleased = false;
    protected Object unmarshaledEntity;
    protected boolean streamWasRead = false;

    public void setProviderFactory(ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
    }

    public void setBaseMethod(HttpMethodBase baseMethod) {
        this.baseMethod = baseMethod;
    }

    public void setReturnType(Class returnType) {
        this.returnType = returnType;
    }

    public void setGenericReturnType(Type genericReturnType) {
        this.genericReturnType = genericReturnType;
    }

    public void setAnnotations(Annotation[] annotations) {
        this.annotations = annotations;
    }

    public void setHeaders(CaseInsensitiveMap<String> headers) {
        this.headers = headers;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public Object getEntity() {
        try {
            if (this.status == 204) {
                Object var1_1 = null;
                return var1_1;
            }
            if (this.unmarshaledEntity != null) {
                Object object = this.unmarshaledEntity;
                return object;
            }
            if (this.streamWasRead) {
                throw new RuntimeException("Stream was already read");
            }
            String mediaType = this.headers.getFirst("Content-Type");
            MediaType media = MediaType.valueOf((String)mediaType);
            MessageBodyReader reader = this.providerFactory.getMessageBodyReader(this.returnType, this.genericReturnType, this.annotations, media);
            if (reader == null) {
                throw new RuntimeException("Unable to find a MessageBodyReader of content-type " + mediaType);
            }
            this.streamWasRead = true;
            try {
                Object object = this.unmarshaledEntity = reader.readFrom(this.returnType, this.genericReturnType, this.annotations, media, this.headers, this.baseMethod.getResponseBodyAsStream());
                return object;
            }
            catch (Exception e) {
                throw new RuntimeException("Failure reading from MessageBodyReader: " + reader.getClass().getName(), e);
            }
        }
        finally {
            this.wasReleased = true;
            this.baseMethod.releaseConnection();
        }
    }

    public Object getEntity(Class type, Type genericType) {
        try {
            if (this.status == 204) {
                Object var3_3 = null;
                return var3_3;
            }
            if (this.unmarshaledEntity != null) {
                Object object = this.unmarshaledEntity;
                return object;
            }
            if (this.streamWasRead) {
                throw new RuntimeException("Stream was already read");
            }
            String mediaType = this.headers.getFirst("Content-Type");
            MediaType media = MediaType.valueOf((String)mediaType);
            MessageBodyReader reader = this.providerFactory.getMessageBodyReader(type, genericType, null, media);
            if (reader == null) {
                throw new RuntimeException("Unable to find a MessageBodyReader of content-type " + mediaType);
            }
            this.streamWasRead = true;
            try {
                Object object = this.unmarshaledEntity = reader.readFrom(type, genericType, null, media, this.headers, this.baseMethod.getResponseBodyAsStream());
                return object;
            }
            catch (Exception e) {
                throw new RuntimeException("Failure reading from MessageBodyReader: " + reader.getClass().getName(), e);
            }
        }
        finally {
            this.wasReleased = true;
            this.baseMethod.releaseConnection();
        }
    }

    public Object getEntity(GenericType genericType) {
        return this.getEntity(genericType.getType(), genericType.getGenericType());
    }

    public MultivaluedMap getHeaders() {
        return this.headers;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    protected void finalize() throws Throwable {
        if (!this.wasReleased) {
            this.baseMethod.releaseConnection();
        }
    }
}

