/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.specimpl.RequestImpl;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class DispatcherUtilities {
    private ResteasyProviderFactory providerFactory;
    private Registry registry;

    public DispatcherUtilities(ResteasyProviderFactory providerFactory, Registry registry) {
        this.providerFactory = providerFactory;
        this.registry = registry;
    }

    public MediaType resolveContentType(Response jaxrsResponse) {
        MediaType responseContentType = null;
        Object type = jaxrsResponse.getMetadata().getFirst((Object)"Content-Type");
        if (type == null) {
            return MediaType.valueOf((String)"*/*");
        }
        responseContentType = type instanceof MediaType ? (MediaType)type : MediaType.valueOf((String)type.toString());
        return responseContentType;
    }

    public void outputHeaders(HttpResponse response, Response jaxrsResponse) {
        if (jaxrsResponse.getMetadata() != null && jaxrsResponse.getMetadata().size() > 0) {
            response.getOutputHeaders().putAll((Map)jaxrsResponse.getMetadata());
        }
    }

    public void writeCookies(HttpResponse response, Response jaxrsResponse) {
        List cookies;
        if (jaxrsResponse.getMetadata() != null && (cookies = (List)jaxrsResponse.getMetadata().get((Object)"Set-Cookie")) != null) {
            Iterator it = cookies.iterator();
            while (it.hasNext()) {
                Object next = it.next();
                if (!(next instanceof NewCookie)) continue;
                NewCookie cookie = (NewCookie)next;
                response.addNewCookie(cookie);
                it.remove();
            }
            if (cookies.size() < 1) {
                jaxrsResponse.getMetadata().remove((Object)"Set-Cookie");
            }
        }
    }

    public void pushContextObjects(HttpRequest request, HttpResponse response) {
        ResteasyProviderFactory.pushContext(HttpRequest.class, request);
        ResteasyProviderFactory.pushContext(HttpResponse.class, response);
        ResteasyProviderFactory.pushContext(HttpHeaders.class, request.getHttpHeaders());
        ResteasyProviderFactory.pushContext(UriInfo.class, request.getUri());
        ResteasyProviderFactory.pushContext(Request.class, new RequestImpl(request));
        ResteasyProviderFactory.pushContext(Providers.class, (Object)this.providerFactory);
        ResteasyProviderFactory.pushContext(Registry.class, this.registry);
    }

    public ResteasyProviderFactory getProviderFactory() {
        return this.providerFactory;
    }
}

