/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.ws.rs.Encoded;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import org.jboss.resteasy.core.ValueInjector;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.LoggableFailure;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.FindAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageBodyParameterInjector
implements ValueInjector {
    private Class type;
    private Type genericType;
    private Annotation[] annotations;
    private ResteasyProviderFactory factory;

    public MessageBodyParameterInjector(Class type, Type genericType, Annotation[] annotations, ResteasyProviderFactory factory) {
        this.type = type;
        this.factory = factory;
        this.genericType = genericType;
        this.annotations = annotations;
    }

    public boolean isFormData(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!mediaType.equals((Object)MediaType.APPLICATION_FORM_URLENCODED_TYPE)) {
            return false;
        }
        if (!MultivaluedMap.class.isAssignableFrom(type)) {
            return false;
        }
        if (genericType == null) {
            return true;
        }
        if (!(genericType instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType params = (ParameterizedType)genericType;
        if (params.getActualTypeArguments().length != 2) {
            return false;
        }
        return params.getActualTypeArguments()[0].equals(String.class) && params.getActualTypeArguments()[1].equals(String.class);
    }

    @Override
    public Object inject(HttpRequest request, HttpResponse response) {
        try {
            MediaType mediaType = request.getHttpHeaders().getMediaType();
            if (mediaType == null) {
                throw new LoggableFailure("content-type was null and expecting to extract a body", 400);
            }
            if (this.isFormData(this.type, this.genericType, this.annotations, mediaType)) {
                boolean encoded;
                boolean bl = encoded = FindAnnotation.findAnnotation(this.annotations, Encoded.class) != null;
                if (encoded) {
                    return request.getFormParameters();
                }
                return request.getDecodedFormParameters();
            }
            MessageBodyReader reader = this.factory.getMessageBodyReader(this.type, this.genericType, this.annotations, mediaType);
            if (reader == null) {
                throw new LoggableFailure("Could not find message body reader for type: " + this.genericType + " of content type: " + mediaType, 400);
            }
            return reader.readFrom(this.type, this.genericType, this.annotations, mediaType, request.getHttpHeaders().getRequestHeaders(), request.getInputStream());
        }
        catch (IOException e) {
            throw new LoggableFailure("Failure extracting body", (Throwable)e, 500);
        }
    }

    @Override
    public Object inject() {
        throw new RuntimeException("Illegal to inject a message body into a singleton");
    }
}

