/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.Cache;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.core.ResourceMethod;
import org.jboss.resteasy.core.interception.ResourceMethodContext;
import org.jboss.resteasy.core.interception.ResourceMethodInterceptor;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.Failure;

public class ResourceMethodCacheControlInterceptor
implements ResourceMethodInterceptor {
    protected CacheControl cacheControl;

    public boolean accepted(ResourceMethod resourceMethod) {
        if (!resourceMethod.getHttpMethods().contains("GET")) {
            return false;
        }
        Cache cache = resourceMethod.getResourceClass().getAnnotation(Cache.class);
        NoCache nocache = resourceMethod.getResourceClass().getAnnotation(NoCache.class);
        Cache methodCached = resourceMethod.getMethod().getAnnotation(Cache.class);
        NoCache noMethodCache = resourceMethod.getMethod().getAnnotation(NoCache.class);
        if (methodCached != null) {
            this.initCacheControl(methodCached);
        } else if (noMethodCache != null) {
            this.cacheControl = new CacheControl();
            this.cacheControl.setNoCache(true);
        } else if (cache != null) {
            this.initCacheControl(methodCached);
        } else if (nocache != null) {
            this.cacheControl = new CacheControl();
            this.cacheControl.setNoCache(true);
            for (String field : nocache.fields()) {
                this.cacheControl.getNoCacheFields().add(field);
            }
        }
        return this.cacheControl != null;
    }

    protected void initCacheControl(Cache methodCached) {
        this.cacheControl = new CacheControl();
        if (methodCached.isPrivate()) {
            this.cacheControl.setPrivate(true);
        }
        if (methodCached.maxAge() > -1) {
            this.cacheControl.setMaxAge(methodCached.maxAge());
        }
        if (methodCached.sMaxAge() > -1) {
            this.cacheControl.setSMaxAge(methodCached.sMaxAge());
        }
        this.cacheControl.setMustRevalidate(methodCached.mustRevalidate());
        this.cacheControl.setNoStore(methodCached.noStore());
        this.cacheControl.setNoTransform(methodCached.noTransform());
        this.cacheControl.setProxyRevalidate(methodCached.proxyRevalidate());
    }

    public Response invoke(ResourceMethodContext ctx) throws Failure, ApplicationException, WebApplicationException {
        Response response = ctx.proceed();
        if (response.getStatus() == 200) {
            return Response.fromResponse((Response)response).cacheControl(this.cacheControl).build();
        }
        return response;
    }
}

