/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import org.jboss.resteasy.core.DispatcherUtilities;
import org.jboss.resteasy.specimpl.ResponseImpl;
import org.jboss.resteasy.spi.HttpResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseInvoker {
    private Response jaxrsResponse;
    private Object entity;
    private Type genericType = null;
    private Annotation[] annotations = null;
    private DispatcherUtilities dispatcherUtilities;
    private Class<? extends Object> type;
    private MediaType contentType;
    private MessageBodyWriter writer;

    public ResponseInvoker(DispatcherUtilities dispatcherUtilities, Response jaxrsResponse) {
        this.jaxrsResponse = jaxrsResponse;
        this.entity = jaxrsResponse.getEntity();
        this.dispatcherUtilities = dispatcherUtilities;
        if (this.entity != null) {
            this.initialize();
        }
    }

    protected void initialize() {
        this.contentType = this.dispatcherUtilities.resolveContentType(this.jaxrsResponse);
        if (this.entity instanceof GenericEntity) {
            GenericEntity ge = (GenericEntity)this.entity;
            this.genericType = ge.getType();
            this.entity = ge.getEntity();
            this.type = this.entity.getClass();
        }
        if (this.jaxrsResponse instanceof ResponseImpl) {
            if (this.genericType == null) {
                this.genericType = ((ResponseImpl)this.jaxrsResponse).getGenericType();
            }
            this.annotations = ((ResponseImpl)this.jaxrsResponse).getAnnotations();
        }
        this.type = this.entity.getClass();
        this.writer = this.dispatcherUtilities.getProviderFactory().getMessageBodyWriter(this.type, this.genericType, this.annotations, this.contentType);
    }

    public MessageBodyWriter getWriter() {
        return this.writer;
    }

    public long getResponseSize() {
        if (this.writer == null) {
            return -1L;
        }
        return this.writer.getSize(this.entity, this.type, this.genericType, this.annotations, this.contentType);
    }

    public Class<? extends Object> getType() {
        return this.type;
    }

    public MediaType getContentType() {
        return this.contentType;
    }

    public void setContentType(MediaType contentType) {
        this.contentType = contentType;
    }

    public void writeTo(HttpResponse response) throws WebApplicationException, IOException {
        this.writer.writeTo(this.entity, this.type, this.genericType, this.annotations, this.contentType, response.getOutputHeaders(), response.getOutputStream());
    }

    public Object getEntity() {
        return this.entity;
    }
}

