/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.registry;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.ResourceLocator;
import org.jboss.resteasy.core.ResourceMethod;
import org.jboss.resteasy.core.registry.PathParamSegment;
import org.jboss.resteasy.core.registry.Segment;
import org.jboss.resteasy.core.registry.SimpleSegment;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.LoggableFailure;
import org.jboss.resteasy.util.IsHttpMethod;
import org.jboss.resteasy.util.PathHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootSegment
extends Segment {
    protected Map<String, SimpleSegment> simpleSegments = new HashMap<String, SimpleSegment>();
    protected Map<String, PathParamSegment> resourceExpressions = new HashMap<String, PathParamSegment>();
    protected List<PathParamSegment> sortedResourceExpressions = new ArrayList<PathParamSegment>();
    protected Map<String, PathParamSegment> locatorExpressions = new HashMap<String, PathParamSegment>();
    protected List<PathParamSegment> sortedLocatorExpressions = new ArrayList<PathParamSegment>();
    protected Map<String, List<ResourceInvoker>> bounded = new LinkedHashMap<String, List<ResourceInvoker>>();

    public Map<String, List<ResourceInvoker>> getBounded() {
        return this.bounded;
    }

    @Override
    protected boolean isEmpty() {
        return super.isEmpty() && this.simpleSegments.size() == 0 && this.resourceExpressions.size() == 0 && this.locatorExpressions.size() == 0;
    }

    protected void addPath(String[] segments, int index, ResourceInvoker invoker) {
        String segment = segments[index];
        Matcher withPathParam = PathHelper.URI_PARAM_PATTERN.matcher(segment);
        if (withPathParam.find()) {
            String expression = this.recombineSegments(segments, index);
            if (invoker instanceof ResourceLocator) {
                PathParamSegment segmentNode = this.locatorExpressions.get(expression);
                if (segmentNode != null) {
                    throw new LoggableFailure("You cannot have 2 locators for same path: " + expression);
                }
                segmentNode = new PathParamSegment(expression);
                segmentNode.locator = (ResourceLocator)invoker;
                this.locatorExpressions.put(segmentNode.getPathExpression(), segmentNode);
                this.sortedLocatorExpressions.add(segmentNode);
                Collections.sort(this.sortedLocatorExpressions);
            } else {
                PathParamSegment segmentNode = this.resourceExpressions.get(expression);
                if (segmentNode == null) {
                    segmentNode = new PathParamSegment(expression);
                    this.resourceExpressions.put(segmentNode.getPathExpression(), segmentNode);
                    this.sortedResourceExpressions.add(segmentNode);
                    Collections.sort(this.sortedResourceExpressions);
                }
                segmentNode.methods.add((ResourceMethod)invoker);
            }
        } else {
            SimpleSegment segmentNode = this.simpleSegments.get(segment);
            if (segmentNode == null) {
                segmentNode = new SimpleSegment(segment);
                this.simpleSegments.put(segment, segmentNode);
            }
            if (segments.length > index + 1) {
                segmentNode.addPath(segments, index + 1, invoker);
            } else if (invoker instanceof ResourceLocator) {
                segmentNode.locator = (ResourceLocator)invoker;
            } else {
                segmentNode.methods.add((ResourceMethod)invoker);
            }
        }
    }

    private String recombineSegments(String[] segments, int index) {
        String expression = "";
        boolean first = true;
        for (int i = index; i < segments.length; ++i) {
            if (first) {
                first = false;
            } else {
                expression = expression + "/";
            }
            expression = expression + segments[i];
        }
        return expression;
    }

    protected boolean isLocator(Method method) {
        return IsHttpMethod.getHttpMethods(method) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceInvoker removePath(String[] segments, int index, Method method) {
        String segment = segments[index];
        Matcher withPathParam = PathHelper.URI_PARAM_PATTERN.matcher(segment);
        if (withPathParam.find()) {
            String expression = this.recombineSegments(segments, index);
            if (this.isLocator(method)) {
                PathParamSegment rtn = this.locatorExpressions.remove(expression);
                if (rtn != null) {
                    this.sortedLocatorExpressions.remove(rtn);
                    return rtn.locator;
                }
                return null;
            }
            PathParamSegment node = this.resourceExpressions.get(expression);
            if (node == null) {
                return null;
            }
            Iterator it = node.methods.iterator();
            try {
                while (it.hasNext()) {
                    ResourceMethod invoker = (ResourceMethod)it.next();
                    if (!invoker.getMethod().equals(method)) continue;
                    it.remove();
                    ResourceMethod resourceMethod = invoker;
                    return resourceMethod;
                }
            }
            finally {
                PathParamSegment seg;
                if (node.isEmpty() && (seg = this.resourceExpressions.remove(expression)) != null) {
                    this.sortedResourceExpressions.remove(seg);
                }
            }
        }
        SimpleSegment segmentNode = this.simpleSegments.get(segment);
        if (segmentNode == null) {
            return null;
        }
        if (segments.length > index + 1) {
            try {
                ResourceInvoker node = segmentNode.removePath(segments, index + 1, method);
                return node;
            }
            finally {
                if (segmentNode.isEmpty()) {
                    this.simpleSegments.remove(segment);
                }
            }
        }
        try {
            if (this.isLocator(method)) {
                ResourceLocator loc = segmentNode.locator;
                segmentNode.locator = null;
                ResourceLocator it = loc;
                return it;
            }
            Iterator it = segmentNode.methods.iterator();
            while (it.hasNext()) {
                ResourceMethod invoker = (ResourceMethod)it.next();
                if (!invoker.getMethod().equals(method)) continue;
                it.remove();
                ResourceMethod resourceMethod = invoker;
                return resourceMethod;
            }
        }
        finally {
            if (segmentNode.isEmpty()) {
                this.simpleSegments.remove(segment);
            }
        }
        return null;
    }

    public void addPath(String path, ResourceInvoker invoker) {
        List<ResourceInvoker> list = this.bounded.get(path);
        if (list == null) {
            list = new ArrayList<ResourceInvoker>();
            this.bounded.put(path, list);
        }
        list.add(invoker);
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        MultivaluedMapImpl<String, String> pathParamExpr = new MultivaluedMapImpl<String, String>();
        StringBuffer newPath = RootSegment.pullPathParamExpressions(path, pathParamExpr);
        path = newPath.toString();
        String[] segments = path.split("/");
        for (int i = 0; i < segments.length; ++i) {
            segments[i] = RootSegment.putBackPathParamExpressions(segments[i], pathParamExpr);
        }
        this.addPath(segments, 0, invoker);
    }

    public ResourceInvoker removePath(String path, Method method) {
        List<ResourceInvoker> list = this.bounded.get(path);
        if (list != null) {
            ResourceInvoker removed = null;
            for (ResourceInvoker invoker : list) {
                if (invoker instanceof ResourceMethod) {
                    ResourceMethod rm = (ResourceMethod)invoker;
                    if (!rm.getMethod().equals(method)) continue;
                    removed = rm;
                    break;
                }
                ResourceLocator locator = (ResourceLocator)invoker;
                if (!locator.getMethod().equals(method)) continue;
                removed = locator;
                break;
            }
            list.remove(removed);
            if (list.size() == 0) {
                this.bounded.remove(path);
            }
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        MultivaluedMapImpl<String, String> pathParamExpr = new MultivaluedMapImpl<String, String>();
        StringBuffer newPath = RootSegment.pullPathParamExpressions(path, pathParamExpr);
        path = newPath.toString();
        String[] segments = path.split("/");
        for (int i = 0; i < segments.length; ++i) {
            segments[i] = RootSegment.putBackPathParamExpressions(segments[i], pathParamExpr);
        }
        return this.removePath(segments, 0, method);
    }

    protected ResourceInvoker matchChildren(HttpRequest request, String path, int start) {
        int endOfSegmentIndex;
        String simpleSegment = null;
        simpleSegment = start == path.length() ? "" : ((endOfSegmentIndex = path.indexOf(47, start)) > -1 ? path.substring(start, endOfSegmentIndex) : path.substring(start));
        Failure lastFailure = null;
        SimpleSegment segment = this.simpleSegments.get(simpleSegment);
        if (segment != null) {
            try {
                return segment.matchSimple(request, path, start);
            }
            catch (Failure e) {
                lastFailure = e;
            }
        }
        for (PathParamSegment pathParamSegment : this.sortedResourceExpressions) {
            try {
                return pathParamSegment.matchPattern(request, path, start);
            }
            catch (Failure e) {
                lastFailure = e;
            }
        }
        for (PathParamSegment pathParamSegment : this.sortedLocatorExpressions) {
            try {
                return pathParamSegment.matchPattern(request, path, start);
            }
            catch (Failure e) {
                lastFailure = e;
            }
        }
        if (lastFailure != null) {
            throw lastFailure;
        }
        throw new Failure("Could not find resource for path: " + path, 404);
    }

    public ResourceInvoker matchRoot(HttpRequest request) {
        int start = 0;
        return this.matchRoot(request, start);
    }

    public ResourceInvoker matchRoot(HttpRequest request, int start) {
        String path = request.getPreprocessedPath();
        if (start < path.length() && path.charAt(start) == '/') {
            ++start;
        }
        return this.matchChildren(request, path, start);
    }

    private static StringBuffer pullPathParamExpressions(String path, MultivaluedMapImpl<String, String> pathParamExpr) {
        Matcher matcher = PathHelper.URI_PARAM_WITH_REGEX_PATTERN.matcher(path);
        StringBuffer newPath = new StringBuffer();
        while (matcher.find()) {
            String name = matcher.group(1);
            String regex = matcher.group(3);
            pathParamExpr.add(name, regex);
            matcher.appendReplacement(newPath, "{$1:x}");
        }
        matcher.appendTail(newPath);
        return newPath;
    }

    private static String putBackPathParamExpressions(String path, MultivaluedMapImpl<String, String> pathParamExpr) {
        Matcher matcher = PathHelper.URI_PARAM_WITH_REGEX_PATTERN.matcher(path);
        StringBuffer newPath = new StringBuffer();
        while (matcher.find()) {
            String name = matcher.group(1);
            String val = (String)((List)pathParamExpr.get(name)).remove(0);
            matcher.appendReplacement(newPath, "{$1:" + val + "}");
        }
        matcher.appendTail(newPath);
        return newPath.toString();
    }
}

