/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.util.MediaTypeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaTypeMap<T> {
    private static Pattern COMPOSITE_PATTERN = Pattern.compile("([^\\+]+)\\+(.+)");
    private static Pattern COMPOSITE_SUBTYPE_WILDCARD_PATTERN = Pattern.compile("\\*\\+(.+)");
    private static Pattern WILD_SUBTYPE_COMPOSITE_PATTERN = Pattern.compile("([^\\+]+)\\+\\*");
    private Map<String, SubtypeMap<T>> index = new HashMap<String, SubtypeMap<T>>();
    private List<Entry<T>> wildcards = new ArrayList<Entry<T>>();
    private List<Entry<T>> all = new ArrayList<Entry<T>>();
    private List<T> everything = new ArrayList<T>();

    public void add(MediaType type, T obj) {
        Entry entry = new Entry(type, obj);
        this.all.add(entry);
        Collections.sort(this.all);
        this.everything = MediaTypeMap.convert(this.all);
        if (type.isWildcardType()) {
            this.wildcards.add(entry);
        } else {
            SubtypeMap<T> subtype = this.index.get(type.getType());
            if (subtype == null) {
                subtype = new SubtypeMap();
                this.index.put(type.getType(), subtype);
            }
            subtype.add(type, obj);
        }
    }

    private static <T> List<T> convert(List<Entry<T>> list) {
        ArrayList newList = new ArrayList(list.size());
        for (Entry<T> entry : list) {
            newList.add(entry.object);
        }
        return newList;
    }

    public List<T> getPossible(MediaType accept) {
        ArrayList<Entry<T>> matches = new ArrayList<Entry<T>>();
        if (accept.isWildcardType()) {
            ArrayList<T> copy = new ArrayList<T>();
            copy.addAll(this.everything);
            return copy;
        }
        matches.addAll(this.wildcards);
        SubtypeMap<T> indexed = this.index.get(accept.getType());
        if (indexed != null) {
            matches.addAll(indexed.getPossible(accept));
        }
        Collections.sort(matches);
        return MediaTypeMap.convert(matches);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SubtypeMap<T> {
        private Map<String, List<Entry<T>>> index = new HashMap<String, List<Entry<T>>>();
        private Map<String, List<Entry<T>>> compositeIndex = new HashMap<String, List<Entry<T>>>();
        private Map<String, List<Entry<T>>> wildCompositeIndex = new HashMap<String, List<Entry<T>>>();
        private List<Entry<T>> wildcards = new ArrayList<Entry<T>>();
        private List<Entry<T>> all = new ArrayList<Entry<T>>();

        private SubtypeMap() {
        }

        public void add(MediaType type, T obj) {
            Entry entry = new Entry(type, obj);
            this.all.add(entry);
            Matcher matcher = COMPOSITE_SUBTYPE_WILDCARD_PATTERN.matcher(type.getSubtype());
            Matcher wildCompositeMatcher = WILD_SUBTYPE_COMPOSITE_PATTERN.matcher(type.getSubtype());
            if (type.isWildcardSubtype()) {
                this.wildcards.add(entry);
            } else if (matcher.matches()) {
                String main = matcher.group(1);
                List<Entry<T>> list = this.compositeIndex.get(main);
                if (list == null) {
                    list = new ArrayList<Entry<T>>();
                    this.compositeIndex.put(main, list);
                }
                list.add(entry);
            } else if (wildCompositeMatcher.matches()) {
                String main = wildCompositeMatcher.group(1);
                List<Entry<T>> list = this.wildCompositeIndex.get(main);
                if (list == null) {
                    list = new ArrayList<Entry<T>>();
                    this.wildCompositeIndex.put(main, list);
                }
                list.add(entry);
            } else {
                List<Entry<T>> list = this.index.get(type.getSubtype());
                if (list == null) {
                    list = new ArrayList<Entry<T>>();
                    this.index.put(type.getSubtype(), list);
                }
                list.add(entry);
            }
        }

        public List<Entry<T>> getPossible(MediaType accept) {
            List<Entry<T>> indexed2;
            if (accept.isWildcardSubtype()) {
                return this.all;
            }
            ArrayList<Entry<T>> matches = new ArrayList<Entry<T>>();
            List<Entry<T>> indexed = this.index.get(accept.getSubtype());
            if (indexed != null) {
                matches.addAll(indexed);
            }
            Matcher matcher = COMPOSITE_PATTERN.matcher(accept.getSubtype());
            String compositeKey = accept.getSubtype();
            if (matcher.matches()) {
                String wildCompositeKey = matcher.group(1);
                List<Entry<T>> windex = this.wildCompositeIndex.get(wildCompositeKey);
                if (windex != null) {
                    matches.addAll(windex);
                }
                compositeKey = matcher.group(2);
            }
            if ((indexed2 = this.compositeIndex.get(compositeKey)) != null) {
                matches.addAll(indexed2);
            }
            matches.addAll(this.wildcards);
            return matches;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<T>
    implements Comparable<Entry> {
        public MediaType mediaType;
        public T object;

        private Entry(MediaType mediaType, T object) {
            this.mediaType = mediaType;
            this.object = object;
        }

        @Override
        public int compareTo(Entry entry) {
            return MediaTypeHelper.compareWeight(this.mediaType, entry.mediaType);
        }
    }
}

