/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.activation.DataSource;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.plugins.providers.AbstractEntityProvider;
import org.jboss.resteasy.plugins.providers.ProviderHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Consumes(value={"*/*"})
@Produces(value={"*/*"})
public class DataSourceProvider
extends AbstractEntityProvider<DataSource> {
    public static DataSource readDataSource(InputStream in, MediaType mediaType) throws IOException {
        final String type = mediaType.toString();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ProviderHelper.writeTo(in, baos);
        final byte[] bytes = baos.toByteArray();
        return new DataSource(){

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(bytes);
            }

            public OutputStream getOutputStream() throws IOException {
                throw new IOException("No output stream allowed");
            }

            public String getContentType() {
                return type;
            }

            public String getName() {
                return "";
            }
        };
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return DataSource.class.isAssignableFrom(type);
    }

    public DataSource readFrom(Class<DataSource> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        return DataSourceProvider.readDataSource(entityStream, mediaType);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return DataSource.class.isAssignableFrom(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(DataSource dataSource, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        InputStream in = dataSource.getInputStream();
        try {
            ProviderHelper.writeTo(in, entityStream);
        }
        finally {
            in.close();
        }
    }
}

