/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.cache;

import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.cache.BrowserCache;
import org.jboss.resteasy.client.cache.CacheInterceptor;
import org.jboss.resteasy.client.cache.LightweightBrowserCache;
import org.jboss.resteasy.client.core.ClientInvoker;
import org.jboss.resteasy.client.core.ResteasyClientProxy;
import org.jboss.resteasy.core.interception.ClientExecutionInterceptor;

public class CacheFactory {
    public static LightweightBrowserCache makeCacheable(Object clientProxy) {
        LightweightBrowserCache cache = new LightweightBrowserCache();
        CacheFactory.makeCacheable(clientProxy, (BrowserCache)cache);
        return cache;
    }

    public static void makeCacheable(Object clientProxy, BrowserCache cache) {
        ResteasyClientProxy proxy = (ResteasyClientProxy)clientProxy;
        CacheInterceptor interceptor = new CacheInterceptor(cache);
        for (ClientInvoker invoker : proxy.getResteasyClientInvokers()) {
            ClientExecutionInterceptor[] interceptors;
            if (!invoker.getHttpMethod().equalsIgnoreCase("GET")) continue;
            if (invoker.getExecutionInterceptors() == null) {
                interceptors = new ClientExecutionInterceptor[]{interceptor};
                invoker.setExecutionInterceptors(interceptors);
                continue;
            }
            interceptors = new ClientExecutionInterceptor[invoker.getExecutionInterceptors().length + 1];
            System.arraycopy(invoker.getExecutionInterceptors(), 0, interceptors, 1, invoker.getExecutionInterceptors().length);
            interceptors[0] = interceptor;
            invoker.setExecutionInterceptors(interceptors);
        }
    }

    public static void makeCacheable(ClientRequest request, BrowserCache cache) {
        CacheInterceptor interceptor = new CacheInterceptor(cache);
        if (request.getExecutionInterceptors() == null) {
            ClientExecutionInterceptor[] interceptors = new ClientExecutionInterceptor[]{interceptor};
            interceptors[0] = interceptor;
            request.setExecutionInterceptors(interceptors);
        } else {
            ClientExecutionInterceptor[] interceptors = new ClientExecutionInterceptor[request.getExecutionInterceptors().length + 1];
            System.arraycopy(request.getExecutionInterceptors(), 0, interceptors, 1, request.getExecutionInterceptors().length);
            interceptors[0] = interceptor;
            request.setExecutionInterceptors(interceptors);
        }
    }
}

