/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.core.ThreadLocalResteasyProviderFactory;
import org.jboss.resteasy.plugins.server.servlet.HttpServletInputMessage;
import org.jboss.resteasy.plugins.server.servlet.HttpServletResponseWrapper;
import org.jboss.resteasy.plugins.server.servlet.ServletSecurityContext;
import org.jboss.resteasy.plugins.server.servlet.ServletUtil;
import org.jboss.resteasy.specimpl.UriInfoImpl;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServletDispatcher
extends HttpServlet {
    protected Dispatcher dispatcher;
    protected ResteasyProviderFactory providerFactory;
    private static final Logger logger = LoggerFactory.getLogger(HttpServletDispatcher.class);
    private String servletMappingPrefix = "";

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this.providerFactory = (ResteasyProviderFactory)((Object)servletConfig.getServletContext().getAttribute(ResteasyProviderFactory.class.getName()));
        if (this.providerFactory == null) {
            this.providerFactory = new ResteasyProviderFactory();
            servletConfig.getServletContext().setAttribute(ResteasyProviderFactory.class.getName(), (Object)this.providerFactory);
        }
        this.dispatcher = (Dispatcher)servletConfig.getServletContext().getAttribute(Dispatcher.class.getName());
        if (this.dispatcher == null) {
            this.dispatcher = new SynchronousDispatcher(this.providerFactory);
            servletConfig.getServletContext().setAttribute(Dispatcher.class.getName(), (Object)this.dispatcher);
            servletConfig.getServletContext().setAttribute(Registry.class.getName(), (Object)this.dispatcher.getRegistry());
        }
        this.servletMappingPrefix = servletConfig.getServletContext().getInitParameter("resteasy.servlet.mapping.prefix");
        if (this.servletMappingPrefix == null) {
            this.servletMappingPrefix = "";
        }
        this.servletMappingPrefix.trim();
    }

    public void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.service(httpServletRequest.getMethod(), httpServletRequest, httpServletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(String httpMethod, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ResteasyProviderFactory defaultInstance;
        try {
            defaultInstance = ResteasyProviderFactory.getInstance();
            if (defaultInstance instanceof ThreadLocalResteasyProviderFactory) {
                ThreadLocalResteasyProviderFactory.push(this.providerFactory);
            }
            HttpHeaders headers = ServletUtil.extractHttpHeaders(request);
            UriInfoImpl uriInfo = ServletUtil.extractUriInfo(request, this.servletMappingPrefix);
            HttpResponse theResponse = this.createServletResponse(response);
            HttpRequest in = this.createHttpRequest(httpMethod, request, headers, uriInfo, theResponse);
            try {
                ResteasyProviderFactory.pushContext(HttpServletRequest.class, request);
                ResteasyProviderFactory.pushContext(HttpServletResponse.class, response);
                ResteasyProviderFactory.pushContext(SecurityContext.class, new ServletSecurityContext(request));
                this.dispatcher.invoke(in, theResponse);
            }
            finally {
                ResteasyProviderFactory.clearContextData();
            }
        }
        finally {
            defaultInstance = ResteasyProviderFactory.getInstance();
            if (defaultInstance instanceof ThreadLocalResteasyProviderFactory) {
                ThreadLocalResteasyProviderFactory.pop();
            }
        }
    }

    protected HttpRequest createHttpRequest(String httpMethod, HttpServletRequest request, HttpHeaders headers, UriInfoImpl uriInfo, HttpResponse theResponse) {
        return new HttpServletInputMessage(request, theResponse, headers, uriInfo, httpMethod.toUpperCase(), (SynchronousDispatcher)this.dispatcher);
    }

    protected HttpResponse createServletResponse(HttpServletResponse response) {
        return new HttpServletResponseWrapper(response, this.dispatcher.getProviderFactory());
    }
}

