/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.core.extractors;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.ClientResponseType;
import org.jboss.resteasy.annotations.ResponseObject;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.EntityTypeFactory;
import org.jboss.resteasy.client.core.extractors.BodyEntityExtractor;
import org.jboss.resteasy.client.core.extractors.ClientRequestContext;
import org.jboss.resteasy.client.core.extractors.EntityExtractor;
import org.jboss.resteasy.client.core.extractors.EntityExtractorFactory;
import org.jboss.resteasy.client.core.extractors.ResponseObjectEntityExtractorFactory;
import org.jboss.resteasy.client.core.extractors.ResponseObjectProxy;
import org.jboss.resteasy.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEntityExtractorFactory
implements EntityExtractorFactory {
    public static final EntityExtractor clientResponseExtractor = new EntityExtractor<ClientResponse>(){

        @Override
        public ClientResponse extractEntity(ClientRequestContext context, Object ... args) {
            return context.getClientResponse();
        }
    };

    public static EntityExtractor<Response.Status> createStatusExtractor(final boolean release) {
        return new EntityExtractor<Response.Status>(){

            @Override
            public Response.Status extractEntity(ClientRequestContext context, Object ... args) {
                if (release) {
                    context.getClientResponse().releaseConnection();
                }
                return context.getClientResponse().getResponseStatus();
            }
        };
    }

    public static final EntityExtractor createVoidExtractor(final boolean release) {
        return new EntityExtractor(){

            public Object extractEntity(ClientRequestContext context, Object ... args) {
                if (release) {
                    context.getClientResponse().releaseConnection();
                }
                return null;
            }
        };
    }

    @Override
    public EntityExtractor createExtractor(Method method) {
        Class<?> returnType = method.getReturnType();
        if (DefaultEntityExtractorFactory.isVoidReturnType(returnType)) {
            return DefaultEntityExtractorFactory.createVoidExtractor(true);
        }
        if (returnType.equals(Response.Status.class)) {
            return DefaultEntityExtractorFactory.createStatusExtractor(true);
        }
        if (Response.class.isAssignableFrom(returnType)) {
            return this.createResponseTypeEntityExtractor(method);
        }
        if (returnType.isInterface() && returnType.isAnnotationPresent(ResponseObject.class)) {
            return new ResponseObjectProxy(method, new ResponseObjectEntityExtractorFactory());
        }
        return new BodyEntityExtractor(method);
    }

    protected EntityExtractor createResponseTypeEntityExtractor(Method method) {
        ClientResponseType responseHint = method.getAnnotation(ClientResponseType.class);
        if (responseHint != null) {
            final Class responseHintReturnType = responseHint.entityType();
            if (DefaultEntityExtractorFactory.isVoidReturnType(responseHintReturnType)) {
                final Class<? extends EntityTypeFactory> entityTypeFactory = responseHint.entityTypeFactory();
                return new EntityExtractor(){

                    public Object extractEntity(ClientRequestContext context, Object ... args) {
                        EntityTypeFactory factory = null;
                        try {
                            factory = (EntityTypeFactory)entityTypeFactory.newInstance();
                        }
                        catch (InstantiationException e) {
                            throw context.getClientResponse().createResponseFailure("Could not create a default entity type factory of type " + entityTypeFactory.getClass().getName());
                        }
                        catch (IllegalAccessException e) {
                            throw context.getClientResponse().createResponseFailure("Could not create a default entity type factory of type " + entityTypeFactory.getClass().getName() + ". " + e.getMessage());
                        }
                        context.getClientResponse().setReturnType(factory.getEntityType(context.getClientResponse().getStatus(), context.getClientResponse().getMetadata()));
                        return context.getClientResponse();
                    }
                };
            }
            return new EntityExtractor(){

                public Object extractEntity(ClientRequestContext context, Object ... args) {
                    context.getClientResponse().setReturnType(responseHintReturnType);
                    return context.getClientResponse();
                }
            };
        }
        Type methodGenericReturnType = method.getGenericReturnType();
        if (methodGenericReturnType instanceof ParameterizedType) {
            ParameterizedType zType = (ParameterizedType)methodGenericReturnType;
            final Type genericReturnType = zType.getActualTypeArguments()[0];
            final Class<?> responseReturnType = Types.getRawType(genericReturnType);
            return new EntityExtractor(){

                public Object extractEntity(ClientRequestContext context, Object ... args) {
                    context.getClientResponse().setReturnType(responseReturnType);
                    context.getClientResponse().setGenericReturnType(genericReturnType);
                    return context.getClientResponse();
                }
            };
        }
        return clientResponseExtractor;
    }

    public static final boolean isVoidReturnType(Class<?> returnType) {
        return returnType == null || Void.TYPE.equals(returnType) || Void.class.equals(returnType);
    }
}

