/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import javax.ws.rs.ext.RuntimeDelegate;
import org.jboss.resteasy.annotations.interception.ClientInterceptor;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;
import org.jboss.resteasy.client.core.ClientErrorInterceptor;
import org.jboss.resteasy.core.InjectorFactoryImpl;
import org.jboss.resteasy.core.MediaTypeMap;
import org.jboss.resteasy.core.PropertyInjectorImpl;
import org.jboss.resteasy.core.interception.InterceptorRegistry;
import org.jboss.resteasy.plugins.delegates.CacheControlDelegate;
import org.jboss.resteasy.plugins.delegates.CookieHeaderDelegate;
import org.jboss.resteasy.plugins.delegates.EntityTagDelegate;
import org.jboss.resteasy.plugins.delegates.LinkHeaderDelegate;
import org.jboss.resteasy.plugins.delegates.LocaleDelegate;
import org.jboss.resteasy.plugins.delegates.MediaTypeHeaderDelegate;
import org.jboss.resteasy.plugins.delegates.NewCookieHeaderDelegate;
import org.jboss.resteasy.plugins.delegates.UriHeaderDelegate;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.specimpl.ResponseBuilderImpl;
import org.jboss.resteasy.specimpl.UriBuilderImpl;
import org.jboss.resteasy.specimpl.VariantListBuilderImpl;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.ConstructorInjector;
import org.jboss.resteasy.spi.LinkHeader;
import org.jboss.resteasy.spi.StringConverter;
import org.jboss.resteasy.spi.StringParameterUnmarshaller;
import org.jboss.resteasy.spi.interception.ClientExecutionInterceptor;
import org.jboss.resteasy.spi.interception.MessageBodyReaderInterceptor;
import org.jboss.resteasy.spi.interception.MessageBodyWriterInterceptor;
import org.jboss.resteasy.spi.interception.PostProcessInterceptor;
import org.jboss.resteasy.spi.interception.PreProcessInterceptor;
import org.jboss.resteasy.util.ThreadLocalStack;
import org.jboss.resteasy.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResteasyProviderFactory
extends RuntimeDelegate
implements Providers {
    protected MediaTypeMap<MessageBodyKey<MessageBodyReader>> messageBodyReaders = new MediaTypeMap();
    protected MediaTypeMap<MessageBodyKey<MessageBodyWriter>> messageBodyWriters = new MediaTypeMap();
    protected Map<Class<?>, ExceptionMapper> exceptionMappers = new HashMap();
    protected Map<Class<?>, Object> providers = new HashMap();
    protected Map<Class<?>, MediaTypeMap<ContextResolver>> contextResolvers = new HashMap();
    protected Map<Class<?>, StringConverter> stringConverters = new HashMap();
    protected Map<Class<?>, Class<? extends StringParameterUnmarshaller>> stringParameterUnmarshallers = new HashMap();
    protected Map<Class<?>, RuntimeDelegate.HeaderDelegate> headerDelegates = new HashMap();
    protected static AtomicReference<ResteasyProviderFactory> pfr = new AtomicReference();
    protected static ThreadLocalStack<Map<Class<?>, Object>> contextualData = new ThreadLocalStack();
    protected static int maxForwards = 20;
    public static boolean registerBuiltinByDefault = true;
    protected InterceptorRegistry<MessageBodyReaderInterceptor> serverMessageBodyReaderInterceptorRegistry = new InterceptorRegistry<MessageBodyReaderInterceptor>(MessageBodyReaderInterceptor.class, this);
    protected InterceptorRegistry<MessageBodyWriterInterceptor> serverMessageBodyWriterInterceptorRegistry = new InterceptorRegistry<MessageBodyWriterInterceptor>(MessageBodyWriterInterceptor.class, this);
    protected InterceptorRegistry<PreProcessInterceptor> serverPreProcessInterceptorRegistry = new InterceptorRegistry<PreProcessInterceptor>(PreProcessInterceptor.class, this);
    protected InterceptorRegistry<PostProcessInterceptor> serverPostProcessInterceptorRegistry = new InterceptorRegistry<PostProcessInterceptor>(PostProcessInterceptor.class, this);
    protected InterceptorRegistry<MessageBodyReaderInterceptor> clientMessageBodyReaderInterceptorRegistry = new InterceptorRegistry<MessageBodyReaderInterceptor>(MessageBodyReaderInterceptor.class, this);
    protected InterceptorRegistry<MessageBodyWriterInterceptor> clientMessageBodyWriterInterceptorRegistry = new InterceptorRegistry<MessageBodyWriterInterceptor>(MessageBodyWriterInterceptor.class, this);
    protected InterceptorRegistry<ClientExecutionInterceptor> clientExecutionInterceptorRegistry = new InterceptorRegistry<ClientExecutionInterceptor>(ClientExecutionInterceptor.class, this);
    protected List<ClientErrorInterceptor> clientErrorInterceptors = new ArrayList<ClientErrorInterceptor>();
    protected boolean builtinsRegistered = false;

    protected void registerDefaultInterceptorPrecedences(InterceptorRegistry registry) {
        registry.appendPrecedence("SECURITY");
        registry.appendPrecedence("HEADER_DECORATOR");
        registry.appendPrecedence("ENCODER");
        registry.appendPrecedence("REDIRECT");
        registry.appendPrecedence("DECODER");
    }

    protected void registerDefaultInterceptorPrecedences() {
        this.registerDefaultInterceptorPrecedences(this.getServerPreProcessInterceptorRegistry());
        this.registerDefaultInterceptorPrecedences(this.getServerMessageBodyReaderInterceptorRegistry());
        this.registerDefaultInterceptorPrecedences(this.getServerMessageBodyWriterInterceptorRegistry());
        this.registerDefaultInterceptorPrecedences(this.getServerPostProcessInterceptorRegistry());
        this.registerDefaultInterceptorPrecedences(this.getClientMessageBodyReaderInterceptorRegistry());
        this.registerDefaultInterceptorPrecedences(this.getClientMessageBodyWriterInterceptorRegistry());
        this.registerDefaultInterceptorPrecedences(this.getClientExecutionInterceptorRegistry());
    }

    public void appendInterceptorPrecedence(String precedence) {
        this.getServerPreProcessInterceptorRegistry().appendPrecedence(precedence);
        this.getServerMessageBodyReaderInterceptorRegistry().appendPrecedence(precedence);
        this.getServerMessageBodyWriterInterceptorRegistry().appendPrecedence(precedence);
        this.getServerPostProcessInterceptorRegistry().appendPrecedence(precedence);
        this.getClientMessageBodyReaderInterceptorRegistry().appendPrecedence(precedence);
        this.getClientMessageBodyWriterInterceptorRegistry().appendPrecedence(precedence);
        this.getClientExecutionInterceptorRegistry().appendPrecedence(precedence);
    }

    public void insertInterceptorPrecedenceAfter(String after, String newPrecedence) {
        this.getServerPreProcessInterceptorRegistry().insertPrecedenceAfter(after, newPrecedence);
        this.getServerMessageBodyReaderInterceptorRegistry().insertPrecedenceAfter(after, newPrecedence);
        this.getServerMessageBodyWriterInterceptorRegistry().insertPrecedenceAfter(after, newPrecedence);
        this.getServerPostProcessInterceptorRegistry().insertPrecedenceAfter(after, newPrecedence);
        this.getClientMessageBodyReaderInterceptorRegistry().insertPrecedenceAfter(after, newPrecedence);
        this.getClientMessageBodyWriterInterceptorRegistry().insertPrecedenceAfter(after, newPrecedence);
        this.getClientExecutionInterceptorRegistry().insertPrecedenceAfter(after, newPrecedence);
    }

    public void insertInterceptorPrecedenceBefore(String before, String newPrecedence) {
        this.getServerPreProcessInterceptorRegistry().insertPrecedenceBefore(before, newPrecedence);
        this.getServerMessageBodyReaderInterceptorRegistry().insertPrecedenceBefore(before, newPrecedence);
        this.getServerMessageBodyWriterInterceptorRegistry().insertPrecedenceBefore(before, newPrecedence);
        this.getServerPostProcessInterceptorRegistry().insertPrecedenceBefore(before, newPrecedence);
        this.getClientMessageBodyReaderInterceptorRegistry().insertPrecedenceBefore(before, newPrecedence);
        this.getClientMessageBodyWriterInterceptorRegistry().insertPrecedenceBefore(before, newPrecedence);
        this.getClientExecutionInterceptorRegistry().insertPrecedenceBefore(before, newPrecedence);
    }

    public static <T> void pushContext(Class<T> type, T data) {
        ResteasyProviderFactory.getContextDataMap().put(type, data);
    }

    public static void pushContextDataMap(Map<Class<?>, Object> map) {
        contextualData.setLast(map);
    }

    public static Map<Class<?>, Object> getContextDataMap() {
        return ResteasyProviderFactory.getContextDataMap(true);
    }

    public static <T> T getContextData(Class<T> type) {
        return (T)ResteasyProviderFactory.getContextDataMap().get(type);
    }

    public static <T> T popContextData(Class<T> type) {
        return (T)ResteasyProviderFactory.getContextDataMap().remove(type);
    }

    public static void clearContextData() {
        contextualData.clear();
    }

    private static Map<Class<?>, Object> getContextDataMap(boolean create) {
        Map<Class<?>, Object> map = contextualData.get();
        if (map == null) {
            map = new HashMap();
            contextualData.setLast(map);
        }
        return map;
    }

    public static Map<Class<?>, Object> addContextDataLevel() {
        if (ResteasyProviderFactory.getContextDataLevelCount() == maxForwards) {
            throw new BadRequestException("You have exceeded your maximum forwards ResteasyProviderFactory allows.  Last good uri: " + ResteasyProviderFactory.getContextData(UriInfo.class).getPath());
        }
        HashMap map = new HashMap();
        contextualData.push(map);
        return map;
    }

    public static int getContextDataLevelCount() {
        return contextualData.size();
    }

    public static void removeContextDataLevel() {
        contextualData.pop();
    }

    public static void setInstance(ResteasyProviderFactory factory) {
        RuntimeDelegate.setInstance((RuntimeDelegate)factory);
    }

    public static ResteasyProviderFactory getInstance() {
        ResteasyProviderFactory factory = (ResteasyProviderFactory)RuntimeDelegate.getInstance();
        if (registerBuiltinByDefault) {
            RegisterBuiltin.register(factory);
        }
        return factory;
    }

    public static void setRegisterBuiltinByDefault(boolean registerBuiltinByDefault) {
        ResteasyProviderFactory.registerBuiltinByDefault = registerBuiltinByDefault;
    }

    public ResteasyProviderFactory() {
        this.initialize();
    }

    protected void initialize() {
        this.registerDefaultInterceptorPrecedences();
        this.addHeaderDelegate(MediaType.class, new MediaTypeHeaderDelegate());
        this.addHeaderDelegate(NewCookie.class, new NewCookieHeaderDelegate());
        this.addHeaderDelegate(Cookie.class, new CookieHeaderDelegate());
        this.addHeaderDelegate(URI.class, new UriHeaderDelegate());
        this.addHeaderDelegate(EntityTag.class, new EntityTagDelegate());
        this.addHeaderDelegate(CacheControl.class, new CacheControlDelegate());
        this.addHeaderDelegate(Locale.class, new LocaleDelegate());
        this.addHeaderDelegate(LinkHeader.class, new LinkHeaderDelegate());
    }

    public InterceptorRegistry<MessageBodyReaderInterceptor> getServerMessageBodyReaderInterceptorRegistry() {
        return this.serverMessageBodyReaderInterceptorRegistry;
    }

    public InterceptorRegistry<MessageBodyWriterInterceptor> getServerMessageBodyWriterInterceptorRegistry() {
        return this.serverMessageBodyWriterInterceptorRegistry;
    }

    public InterceptorRegistry<PreProcessInterceptor> getServerPreProcessInterceptorRegistry() {
        return this.serverPreProcessInterceptorRegistry;
    }

    public InterceptorRegistry<PostProcessInterceptor> getServerPostProcessInterceptorRegistry() {
        return this.serverPostProcessInterceptorRegistry;
    }

    public InterceptorRegistry<MessageBodyReaderInterceptor> getClientMessageBodyReaderInterceptorRegistry() {
        return this.clientMessageBodyReaderInterceptorRegistry;
    }

    public InterceptorRegistry<MessageBodyWriterInterceptor> getClientMessageBodyWriterInterceptorRegistry() {
        return this.clientMessageBodyWriterInterceptorRegistry;
    }

    public InterceptorRegistry<ClientExecutionInterceptor> getClientExecutionInterceptorRegistry() {
        return this.clientExecutionInterceptorRegistry;
    }

    public boolean isBuiltinsRegistered() {
        return this.builtinsRegistered;
    }

    public void setBuiltinsRegistered(boolean builtinsRegistered) {
        this.builtinsRegistered = builtinsRegistered;
    }

    public UriBuilder createUriBuilder() {
        return new UriBuilderImpl();
    }

    public Response.ResponseBuilder createResponseBuilder() {
        return new ResponseBuilderImpl();
    }

    public Variant.VariantListBuilder createVariantListBuilder() {
        return new VariantListBuilderImpl();
    }

    public <T> RuntimeDelegate.HeaderDelegate<T> createHeaderDelegate(Class<T> tClass) {
        return this.headerDelegates.get(tClass);
    }

    public void addHeaderDelegate(Class clazz, RuntimeDelegate.HeaderDelegate header) {
        this.headerDelegates.put(clazz, header);
    }

    public void addMessageBodyReader(Class<? extends MessageBodyReader> provider) {
        this.addMessageBodyReader(provider, false);
    }

    public void addMessageBodyReader(Class<? extends MessageBodyReader> provider, boolean isBuiltin) {
        MessageBodyReader reader = this.getProviderInstance(provider);
        this.addMessageBodyReader(reader, isBuiltin);
    }

    public void addMessageBodyReader(MessageBodyReader provider) {
        this.addMessageBodyReader(provider, false);
    }

    public void addBuiltInMessageBodyReader(MessageBodyReader provider) {
        this.addMessageBodyReader(provider, true);
    }

    public void addMessageBodyReader(MessageBodyReader provider, boolean isBuiltin) {
        MessageBodyKey key = new MessageBodyKey(MessageBodyReader.class, provider, isBuiltin);
        PropertyInjectorImpl injector = new PropertyInjectorImpl(provider.getClass(), this);
        injector.inject(provider);
        this.providers.put(provider.getClass(), provider);
        Consumes consumeMime = provider.getClass().getAnnotation(Consumes.class);
        if (consumeMime != null) {
            for (String consume : consumeMime.value()) {
                MediaType mime = MediaType.valueOf((String)consume);
                this.messageBodyReaders.add(mime, key);
            }
        } else {
            this.messageBodyReaders.add(new MediaType("*", "*"), key);
        }
    }

    public void addMessageBodyWriter(Class<? extends MessageBodyWriter> provider) {
        this.addMessageBodyWriter(provider, false);
    }

    public void addMessageBodyWriter(Class<? extends MessageBodyWriter> provider, boolean isBuiltin) {
        MessageBodyWriter writer = this.getProviderInstance(provider);
        this.addMessageBodyWriter(writer, isBuiltin);
    }

    public void addMessageBodyWriter(MessageBodyWriter provider) {
        this.addMessageBodyWriter(provider, false);
    }

    public void addBuiltInMessageBodyWriter(MessageBodyWriter provider) {
        this.addMessageBodyWriter(provider, true);
    }

    public void addMessageBodyWriter(MessageBodyWriter provider, boolean isBuiltin) {
        PropertyInjectorImpl injector = new PropertyInjectorImpl(provider.getClass(), this);
        this.providers.put(provider.getClass(), provider);
        injector.inject(provider);
        Produces consumeMime = provider.getClass().getAnnotation(Produces.class);
        MessageBodyKey key = new MessageBodyKey(MessageBodyWriter.class, provider, isBuiltin);
        if (consumeMime != null) {
            for (String consume : consumeMime.value()) {
                MediaType mime = MediaType.valueOf((String)consume);
                this.messageBodyWriters.add(mime, key);
            }
        } else {
            this.messageBodyWriters.add(new MediaType("*", "*"), key);
        }
    }

    public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        List<MessageBodyKey<MessageBodyReader>> readers = this.messageBodyReaders.getPossible(mediaType, type);
        for (MessageBodyKey<MessageBodyReader> reader : readers) {
            if (!((MessageBodyReader)reader.obj).isReadable(type, genericType, annotations, mediaType)) continue;
            return (MessageBodyReader)reader.obj;
        }
        return null;
    }

    public void addExceptionMapper(Class<? extends ExceptionMapper> provider) {
        ExceptionMapper writer = this.getProviderInstance(provider);
        this.addExceptionMapper(writer);
    }

    public void addExceptionMapper(ExceptionMapper provider) {
        Type[] intfs;
        this.providers.put(provider.getClass(), provider);
        PropertyInjectorImpl injector = new PropertyInjectorImpl(provider.getClass(), this);
        injector.inject(provider);
        for (Type type : intfs = provider.getClass().getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(type instanceof ParameterizedType) || !(pt = (ParameterizedType)type).getRawType().equals(ExceptionMapper.class)) continue;
            this.exceptionMappers.put(Types.getRawType(pt.getActualTypeArguments()[0]), provider);
        }
    }

    public void addClientErrorInterceptor(ClientErrorInterceptor handler) {
        if (!this.clientErrorInterceptors.contains(handler)) {
            this.clientErrorInterceptors.add(handler);
        }
    }

    public List<ClientErrorInterceptor> getClientErrorInterceptors() {
        return this.clientErrorInterceptors;
    }

    public void addContextResolver(Class<? extends ContextResolver> resolver) {
        ContextResolver writer = this.getProviderInstance(resolver);
        this.addContextResolver(writer);
    }

    public void addContextResolver(ContextResolver provider) {
        Type[] intfs;
        this.providers.put(provider.getClass(), provider);
        PropertyInjectorImpl injector = new PropertyInjectorImpl(provider.getClass(), this);
        injector.inject(provider);
        for (Type type : intfs = provider.getClass().getGenericInterfaces()) {
            Produces produces;
            ParameterizedType pt;
            if (!(type instanceof ParameterizedType) || !(pt = (ParameterizedType)type).getRawType().equals(ContextResolver.class)) continue;
            Class<?> aClass = Types.getRawType(pt.getActualTypeArguments()[0]);
            MediaTypeMap<Object> resolvers = this.contextResolvers.get(aClass);
            if (resolvers == null) {
                resolvers = new MediaTypeMap();
                this.contextResolvers.put(aClass, resolvers);
            }
            if ((produces = provider.getClass().getAnnotation(Produces.class)) != null) {
                for (String produce : produces.value()) {
                    MediaType mime = MediaType.valueOf((String)produce);
                    resolvers.add(mime, provider);
                }
                continue;
            }
            resolvers.add(new MediaType("*", "*"), provider);
        }
    }

    public void addStringConverter(Class<? extends StringConverter> resolver) {
        StringConverter writer = this.getProviderInstance(resolver);
        this.addStringConverter(writer);
    }

    public void addStringConverter(StringConverter provider) {
        Type[] intfs;
        this.providers.put(provider.getClass(), provider);
        PropertyInjectorImpl injector = new PropertyInjectorImpl(provider.getClass(), this);
        injector.inject(provider);
        for (Type type : intfs = provider.getClass().getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(type instanceof ParameterizedType) || !(pt = (ParameterizedType)type).getRawType().equals(StringConverter.class)) continue;
            Class<?> aClass = Types.getRawType(pt.getActualTypeArguments()[0]);
            this.stringConverters.put(aClass, provider);
        }
    }

    public void addStringParameterUnmarshaller(Class<? extends StringParameterUnmarshaller> provider) {
        Type[] intfs;
        for (Type type : intfs = provider.getClass().getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(type instanceof ParameterizedType) || !(pt = (ParameterizedType)type).getRawType().equals(StringParameterUnmarshaller.class)) continue;
            Class<?> aClass = Types.getRawType(pt.getActualTypeArguments()[0]);
            this.stringParameterUnmarshallers.put(aClass, provider);
        }
    }

    public List<ContextResolver> getContextResolvers(Class<?> clazz, MediaType type) {
        MediaTypeMap<ContextResolver> resolvers = this.contextResolvers.get(clazz);
        if (resolvers == null) {
            return null;
        }
        return resolvers.getPossible(type);
    }

    public StringConverter getStringConverter(Class<?> clazz) {
        if (this.stringConverters.size() == 0) {
            return null;
        }
        return this.stringConverters.get(clazz);
    }

    public <T> StringParameterUnmarshaller<T> createStringParameterUnmarshaller(Class<T> clazz) {
        if (this.stringParameterUnmarshallers.size() == 0) {
            return null;
        }
        Class<? extends StringParameterUnmarshaller> un = this.stringParameterUnmarshallers.get(clazz);
        StringParameterUnmarshaller provider = this.getProviderInstance(un);
        PropertyInjectorImpl injector = new PropertyInjectorImpl(provider.getClass(), this);
        injector.inject(provider);
        return provider;
    }

    public void registerProvider(Class provider) {
        this.registerProvider(provider, false);
    }

    public void registerProvider(Class provider, boolean isBuiltin) {
        if (MessageBodyReader.class.isAssignableFrom(provider)) {
            try {
                this.addMessageBodyReader(provider, isBuiltin);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to instantiate MessageBodyReader", e);
            }
        }
        if (MessageBodyWriter.class.isAssignableFrom(provider)) {
            try {
                this.addMessageBodyWriter(provider, isBuiltin);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to instantiate MessageBodyWriter", e);
            }
        }
        if (ExceptionMapper.class.isAssignableFrom(provider)) {
            try {
                this.addExceptionMapper(provider);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to instantiate ExceptionMapper", e);
            }
        }
        if (ClientExecutionInterceptor.class.isAssignableFrom(provider)) {
            this.clientExecutionInterceptorRegistry.register((ClientExecutionInterceptor)((Object)provider));
        }
        if (PreProcessInterceptor.class.isAssignableFrom(provider)) {
            this.serverPreProcessInterceptorRegistry.register((PreProcessInterceptor)((Object)provider));
        }
        if (PostProcessInterceptor.class.isAssignableFrom(provider)) {
            this.serverPostProcessInterceptorRegistry.register((PostProcessInterceptor)((Object)provider));
        }
        if (MessageBodyWriterInterceptor.class.isAssignableFrom(provider)) {
            if (provider.isAnnotationPresent(ServerInterceptor.class)) {
                this.serverMessageBodyWriterInterceptorRegistry.register((MessageBodyWriterInterceptor)((Object)provider));
            }
            if (provider.isAnnotationPresent(ClientInterceptor.class)) {
                this.clientMessageBodyWriterInterceptorRegistry.register((MessageBodyWriterInterceptor)((Object)provider));
            }
            if (!provider.isAnnotationPresent(ServerInterceptor.class) && !provider.isAnnotationPresent(ClientInterceptor.class)) {
                throw new RuntimeException("Interceptor class must be annotated with @ServerInterceptor and/or @ClientInterceptor");
            }
        }
        if (MessageBodyReaderInterceptor.class.isAssignableFrom(provider)) {
            if (provider.isAnnotationPresent(ServerInterceptor.class)) {
                this.serverMessageBodyReaderInterceptorRegistry.register((MessageBodyReaderInterceptor)((Object)provider));
            }
            if (provider.isAnnotationPresent(ClientInterceptor.class)) {
                this.clientMessageBodyReaderInterceptorRegistry.register((MessageBodyReaderInterceptor)((Object)provider));
            }
            if (!provider.isAnnotationPresent(ServerInterceptor.class) && !provider.isAnnotationPresent(ClientInterceptor.class)) {
                throw new RuntimeException("Interceptor class must be annotated with @ServerInterceptor and/or @ClientInterceptor");
            }
        }
        if (ContextResolver.class.isAssignableFrom(provider)) {
            try {
                this.addContextResolver(provider);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to instantiate ContextResolver", e);
            }
        }
        if (StringConverter.class.isAssignableFrom(provider)) {
            this.addStringConverter(provider);
        }
        if (StringParameterUnmarshaller.class.isAssignableFrom(provider)) {
            this.addStringParameterUnmarshaller(provider);
        }
    }

    public void registerProviderInstance(Object provider) {
        if (provider instanceof MessageBodyReader) {
            try {
                this.addMessageBodyReader((MessageBodyReader)provider);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to instantiate MessageBodyReader", e);
            }
        }
        if (provider instanceof MessageBodyWriter) {
            try {
                this.addMessageBodyWriter((MessageBodyWriter)provider);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to instantiate MessageBodyWriter", e);
            }
        }
        if (provider instanceof ExceptionMapper) {
            try {
                this.addExceptionMapper((ExceptionMapper)provider);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to instantiate ExceptionMapper", e);
            }
        }
        if (provider instanceof ContextResolver) {
            try {
                this.addContextResolver((ContextResolver)provider);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to instantiate ContextResolver", e);
            }
        }
        if (provider instanceof ClientExecutionInterceptor) {
            this.clientExecutionInterceptorRegistry.register((ClientExecutionInterceptor)provider);
        }
        if (provider instanceof PreProcessInterceptor) {
            this.serverPreProcessInterceptorRegistry.register((PreProcessInterceptor)provider);
        }
        if (provider instanceof PostProcessInterceptor) {
            this.serverPostProcessInterceptorRegistry.register((PostProcessInterceptor)provider);
        }
        if (provider instanceof MessageBodyWriterInterceptor) {
            if (provider.getClass().isAnnotationPresent(ServerInterceptor.class)) {
                this.serverMessageBodyWriterInterceptorRegistry.register((MessageBodyWriterInterceptor)provider);
            }
            if (provider.getClass().isAnnotationPresent(ClientInterceptor.class)) {
                this.clientMessageBodyWriterInterceptorRegistry.register((MessageBodyWriterInterceptor)provider);
            }
            if (!provider.getClass().isAnnotationPresent(ServerInterceptor.class) && !provider.getClass().isAnnotationPresent(ClientInterceptor.class)) {
                throw new RuntimeException("Interceptor class " + provider.getClass() + " must be annotated with @ServerInterceptor and/or @ClientInterceptor");
            }
        }
        if (provider instanceof MessageBodyReaderInterceptor) {
            if (provider.getClass().isAnnotationPresent(ServerInterceptor.class)) {
                this.serverMessageBodyReaderInterceptorRegistry.register((MessageBodyReaderInterceptor)provider);
            }
            if (provider.getClass().isAnnotationPresent(ClientInterceptor.class)) {
                this.clientMessageBodyReaderInterceptorRegistry.register((MessageBodyReaderInterceptor)provider);
            }
            if (!provider.getClass().isAnnotationPresent(ServerInterceptor.class) && !provider.getClass().isAnnotationPresent(ClientInterceptor.class)) {
                throw new RuntimeException("Interceptor class " + provider.getClass() + " must be annotated with @ServerInterceptor and/or @ClientInterceptor");
            }
        }
        if (provider instanceof StringConverter) {
            this.addStringConverter((StringConverter)provider);
        }
    }

    public <T> T getProvider(Class<T> providerClass) {
        return (T)this.providers.get(providerClass);
    }

    public <T extends Throwable> ExceptionMapper<T> getExceptionMapper(Class<T> type) {
        return this.exceptionMappers.get(type);
    }

    public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        List<MessageBodyKey<MessageBodyWriter>> writers = this.messageBodyWriters.getPossible(mediaType, type);
        for (MessageBodyKey<MessageBodyWriter> writer : writers) {
            if (!((MessageBodyWriter)writer.obj).isWriteable(type, genericType, annotations, mediaType)) continue;
            return (MessageBodyWriter)writer.obj;
        }
        return null;
    }

    public <T> T createEndpoint(Application applicationConfig, Class<T> endpointType) throws IllegalArgumentException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public <T> ContextResolver<T> getContextResolver(Class<T> contextType, MediaType mediaType) {
        final List<ContextResolver> resolvers = this.getContextResolvers(contextType, mediaType);
        if (resolvers == null) {
            return null;
        }
        if (resolvers.size() == 1) {
            return resolvers.get(0);
        }
        return new ContextResolver<T>(){

            public T getContext(Class type) {
                for (ContextResolver resolver : resolvers) {
                    Object rtn = resolver.getContext(type);
                    if (rtn == null) continue;
                    return rtn;
                }
                return null;
            }
        };
    }

    protected <T> T getProviderInstance(Class<? extends T> clazz) {
        InjectorFactoryImpl factory = new InjectorFactoryImpl(this);
        Constructor<?> constructor = clazz.getDeclaredConstructors()[0];
        ConstructorInjector constructorInjector = factory.createConstructor(constructor);
        Object provider = constructorInjector.construct();
        return (T)provider;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MessageBodyKey<T>
    implements Comparable<MessageBodyKey<T>>,
    MediaTypeMap.Typed {
        public Class readerClass;
        public T obj;
        public boolean isGeneric = false;
        public boolean isBuiltin = false;
        public Class template = null;

        private MessageBodyKey(Class intf, T reader, boolean isBuiltin) {
            this(intf, reader);
            this.isBuiltin = isBuiltin;
        }

        private MessageBodyKey(Class intf, T reader) {
            this.readerClass = reader.getClass();
            this.obj = reader;
            this.template = Types.getTemplateParameterOfInterface(this.readerClass, intf);
            this.isGeneric = this.template == null || Object.class.equals((Object)this.template);
        }

        @Override
        public int compareTo(MessageBodyKey<T> tMessageBodyKey) {
            if (this == tMessageBodyKey) {
                return 0;
            }
            if (this.isGeneric != tMessageBodyKey.isGeneric) {
                if (this.isGeneric) {
                    return 1;
                }
                return -1;
            }
            if (this.isBuiltin == tMessageBodyKey.isBuiltin) {
                return 0;
            }
            if (this.isBuiltin) {
                return 1;
            }
            return -1;
        }

        @Override
        public Class getType() {
            return this.template;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class MessageBodyKeyComparator
        implements Comparator<MessageBodyKey> {
            @Override
            public int compare(MessageBodyKey messageBodyKey, MessageBodyKey messageBodyKey1) {
                return 0;
            }
        }
    }
}

