/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.keys;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import org.jboss.resteasy.security.keys.KeyRepository;

public class KeyStoreKeyRepository
implements KeyRepository {
    private KeyStore keyStore;
    private String password;

    public KeyStoreKeyRepository(InputStream is, String password) {
        this.password = password;
        try {
            this.keyStore = KeyStore.getInstance("JKS");
            this.keyStore.load(is, password.toCharArray());
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    public KeyStoreKeyRepository(String filename, String password) throws IOException {
        this(new FileInputStream(filename), password);
    }

    @Override
    public PrivateKey getPrivateKey(String identity) {
        try {
            Key key = this.keyStore.getKey(identity, this.password.toCharArray());
            return (PrivateKey)key;
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public PublicKey getPublicKey(String identity) {
        Certificate cert = null;
        try {
            cert = this.keyStore.getCertificate(identity);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
        if (cert == null) {
            return null;
        }
        return cert.getPublicKey();
    }
}

