/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.signing;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.security.signing.ContentSignature;
import org.jboss.resteasy.util.GroupParameterParser;

public class ContentSignatures {
    protected List<ContentSignature> signatures = new ArrayList<ContentSignature>();

    public ContentSignatures(String header) {
        this.addSignature(header);
    }

    public void addSignature(String header) {
        GroupParameterParser parser = new GroupParameterParser();
        List<Map<String, String>> sigs = parser.parse(header, ';', ',');
        for (Map<String, String> attributes : sigs) {
            this.signatures.add(new ContentSignature(attributes));
        }
    }

    public ContentSignatures() {
    }

    public String toString() {
        boolean first = true;
        StringBuffer buf = new StringBuffer();
        for (ContentSignature signature : this.signatures) {
            if (first) {
                first = false;
            } else {
                buf.append(",");
            }
            buf.append(signature.toString());
        }
        return buf.toString();
    }

    public ContentSignature addNew() {
        ContentSignature signature = new ContentSignature();
        this.signatures.add(signature);
        return signature;
    }

    public List<ContentSignature> getSignatures() {
        return this.signatures;
    }

    public List<ContentSignature> getBy(String attribute, String value) {
        ArrayList<ContentSignature> result = new ArrayList<ContentSignature>();
        for (ContentSignature signature : this.signatures) {
            String val = signature.getAttributes().get(attribute);
            if (val == null || !val.equals(value)) continue;
            result.add(signature);
        }
        return result;
    }

    public ContentSignature getFirstBy(String attribute, String value) {
        for (ContentSignature signature : this.signatures) {
            String val = signature.getAttributes().get(attribute);
            if (val == null || !val.equals(value)) continue;
            return signature;
        }
        return null;
    }
}

