/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.signing;

import java.io.IOException;
import java.lang.reflect.Method;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.annotations.interception.ClientInterceptor;
import org.jboss.resteasy.annotations.interception.HeaderDecoratorPrecedence;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;
import org.jboss.resteasy.annotations.security.signature.After;
import org.jboss.resteasy.annotations.security.signature.Signed;
import org.jboss.resteasy.security.signing.ContentSignature;
import org.jboss.resteasy.security.signing.ContentSignatures;
import org.jboss.resteasy.spi.interception.AcceptedByMethod;
import org.jboss.resteasy.spi.interception.MessageBodyWriterContext;
import org.jboss.resteasy.spi.interception.MessageBodyWriterInterceptor;

@Provider
@ServerInterceptor
@ClientInterceptor
@HeaderDecoratorPrecedence
public class DigitalSigningHeaderDecorator
implements MessageBodyWriterInterceptor,
AcceptedByMethod {
    protected Signed signed;

    @Override
    public boolean accept(Class declaring, Method method) {
        this.signed = method.getAnnotation(Signed.class);
        if (this.signed == null) {
            this.signed = declaring.getAnnotation(Signed.class);
        }
        return this.signed != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void write(MessageBodyWriterContext context) throws IOException, WebApplicationException {
        After after;
        ContentSignatures signatures = new ContentSignatures();
        if (context.getHeaders().containsKey((Object)"Content-Signature")) {
            Object obj = context.getHeaders().getFirst((Object)"Content-Signature");
            if (!(obj instanceof ContentSignatures)) {
                context.proceed();
                return;
            }
            signatures = (ContentSignatures)obj;
        } else {
            context.getHeaders().putSingle((Object)"Content-Signature", (Object)signatures);
        }
        ContentSignature header = signatures.addNew();
        if (this.signed.keyAlias() != null && !this.signed.keyAlias().equals("")) {
            header.setKeyAlias(this.signed.keyAlias());
        }
        if (this.signed.signer() != null && !this.signed.signer().equals("")) {
            header.setSigner(this.signed.signer(), true, true);
        }
        if (this.signed.algorithm() != null && !this.signed.algorithm().equals("")) {
            header.setAlgorithm(this.signed.algorithm(), true, true);
        }
        if (this.signed.id() != null && !this.signed.id().equals("")) {
            header.setId(this.signed.id(), true);
        }
        if (this.signed.timestamped()) {
            header.setTimestamp();
        }
        if ((after = this.signed.expires()).seconds() > 0 || after.minutes() > 0 || after.hours() > 0 || after.days() > 0 || after.months() > 0 || after.years() > 0) {
            header.setExpiration(after.seconds(), after.minutes(), after.hours(), after.days(), after.months(), after.years());
        }
        context.proceed();
    }
}

