/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.signing;

import java.io.IOException;
import java.lang.reflect.Method;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.annotations.interception.ClientInterceptor;
import org.jboss.resteasy.annotations.interception.HeaderDecoratorPrecedence;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;
import org.jboss.resteasy.annotations.security.signature.After;
import org.jboss.resteasy.annotations.security.signature.Verifications;
import org.jboss.resteasy.annotations.security.signature.Verify;
import org.jboss.resteasy.security.signing.Verification;
import org.jboss.resteasy.security.signing.Verifier;
import org.jboss.resteasy.spi.interception.AcceptedByMethod;
import org.jboss.resteasy.spi.interception.MessageBodyReaderContext;
import org.jboss.resteasy.spi.interception.MessageBodyReaderInterceptor;

@Provider
@ServerInterceptor
@ClientInterceptor
@HeaderDecoratorPrecedence
public class DigitalVerificationHeaderDecorator
implements MessageBodyReaderInterceptor,
AcceptedByMethod {
    protected Verify verify;
    protected Verifications verifications;

    @Override
    public boolean accept(Class declaring, Method method) {
        this.verify = method.getAnnotation(Verify.class);
        this.verifications = method.getAnnotation(Verifications.class);
        return this.verify != null || this.verifications != null;
    }

    @Override
    public Object read(MessageBodyReaderContext context) throws IOException, WebApplicationException {
        Verifier verifier = new Verifier();
        if (this.verify != null) {
            Verification v = this.createVerification(this.verify);
            verifier.getVerifications().add(v);
        }
        if (this.verifications != null) {
            for (Verify ver : this.verifications.value()) {
                Verification v = this.createVerification(ver);
                verifier.getVerifications().add(v);
            }
        }
        context.setAttribute(Verifier.class.getName(), verifier);
        return context.proceed();
    }

    protected Verification createVerification(Verify v) {
        Verification verification = new Verification();
        if (v.algorithm() != null && !v.algorithm().trim().equals("")) {
            verification.setAlgorithm(v.algorithm());
        }
        if (v.signer() != null && !v.signer().trim().equals("")) {
            verification.setSigner(v.signer());
        }
        if (v.id() != null && !v.id().trim().equals("")) {
            verification.setId(v.id());
        }
        if (v.keyAlias() != null && !v.keyAlias().trim().equals("")) {
            verification.setKeyAlias(v.keyAlias());
        }
        if (verification.getKeyAlias() == null) {
            verification.setAttributeAlias(v.attributeKeyAlias());
        }
        verification.setIgnoreExpiration(v.ignoreExpiration());
        After staleAfter = v.stale();
        if (staleAfter.seconds() > 0 || staleAfter.minutes() > 0 || staleAfter.hours() > 0 || staleAfter.days() > 0 || staleAfter.months() > 0 || staleAfter.years() > 0) {
            verification.setStaleCheck(true);
            verification.setStaleSeconds(staleAfter.seconds());
            verification.setStaleMinutes(staleAfter.minutes());
            verification.setStaleHours(staleAfter.hours());
            verification.setStaleDays(staleAfter.days());
            verification.setStaleMonths(staleAfter.months());
            verification.setStaleYears(staleAfter.years());
        }
        return verification;
    }
}

