/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.signing;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.annotations.interception.ClientInterceptor;
import org.jboss.resteasy.annotations.interception.DecoderPrecedence;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;
import org.jboss.resteasy.security.keys.KeyRepository;
import org.jboss.resteasy.security.signing.ContentSignatures;
import org.jboss.resteasy.security.signing.UnauthorizedSignatureException;
import org.jboss.resteasy.security.signing.VerificationResults;
import org.jboss.resteasy.security.signing.Verifier;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.interception.MessageBodyReaderContext;
import org.jboss.resteasy.spi.interception.MessageBodyReaderInterceptor;
import org.jboss.resteasy.util.InputStreamToByteArray;

@Provider
@ClientInterceptor
@ServerInterceptor
@DecoderPrecedence
public class DigitalVerificationInterceptor
implements MessageBodyReaderInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object read(MessageBodyReaderContext context) throws IOException, WebApplicationException {
        Verifier verifier = (Verifier)context.getAttribute(Verifier.class.getName());
        if (verifier == null) {
            return context.proceed();
        }
        MultivaluedMap<String, String> headers = context.getHeaders();
        ContentSignatures contentSignatures = new ContentSignatures();
        List strings = (List)headers.get((Object)"Content-Signature");
        if (strings == null) {
            throw new UnauthorizedSignatureException("There was no Content-Signature header");
        }
        for (String headerVal : strings) {
            try {
                contentSignatures.addSignature(headerVal);
            }
            catch (Exception e) {
                throw new UnauthorizedSignatureException("Malformed Content-Signature header");
            }
        }
        InputStream old = context.getInputStream();
        try {
            VerificationResults results;
            InputStreamToByteArray stream = new InputStreamToByteArray(old);
            context.setInputStream(stream);
            Object rtn = context.proceed();
            byte[] body = stream.toByteArray();
            if (verifier.getRepository() == null) {
                KeyRepository repository = (KeyRepository)context.getAttribute(KeyRepository.class.getName());
                if (repository == null) {
                    repository = ResteasyProviderFactory.getContextData(KeyRepository.class);
                }
                verifier.setRepository(repository);
            }
            if (!(results = verifier.verify(contentSignatures, (Map)headers, body)).isVerified()) {
                throw new UnauthorizedSignatureException(results);
            }
            Object object = rtn;
            return object;
        }
        finally {
            context.setInputStream(old);
        }
    }
}

