/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.signing;

import org.jboss.resteasy.security.signing.VerificationResult;
import org.jboss.resteasy.security.signing.VerificationResultSet;
import org.jboss.resteasy.security.signing.VerificationResults;
import org.jboss.resteasy.spi.LoggableFailure;

public class UnauthorizedSignatureException
extends LoggableFailure {
    protected VerificationResults results;

    public UnauthorizedSignatureException(String reason) {
        super(reason, 401);
    }

    public UnauthorizedSignatureException(VerificationResults results) {
        super(UnauthorizedSignatureException.failedVerifierMessage(results), 401);
        this.results = results;
    }

    public static String failedVerifierMessage(VerificationResults results) {
        StringBuffer msg = new StringBuffer("Failed to verify signatures:");
        for (VerificationResultSet set : results.getResults()) {
            for (VerificationResult result : set.getResults()) {
                msg.append("\r\n");
                if (result.getFailureReason() != null) {
                    msg.append(result.getFailureReason());
                }
                if (result.getFailureException() == null) continue;
                msg.append(" ");
                msg.append(result.getFailureException().getMessage());
            }
        }
        return msg.toString();
    }

    public VerificationResults getResults() {
        return this.results;
    }
}

