/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Path;
import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.ResourceLocator;
import org.jboss.resteasy.core.ResourceMethod;
import org.jboss.resteasy.core.registry.RootSegment;
import org.jboss.resteasy.plugins.server.resourcefactory.JndiResourceFactory;
import org.jboss.resteasy.plugins.server.resourcefactory.POJOResourceFactory;
import org.jboss.resteasy.plugins.server.resourcefactory.SingletonResource;
import org.jboss.resteasy.specimpl.UriBuilderImpl;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.GetRestful;
import org.jboss.resteasy.util.IsHttpMethod;

public class ResourceMethodRegistry
implements Registry {
    protected int size;
    protected ResteasyProviderFactory providerFactory;
    protected RootSegment rootSegment = new RootSegment();

    public ResourceMethodRegistry(ResteasyProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
    }

    public void addPerRequestResource(Class clazz, String basePath) {
        this.addResourceFactory(new POJOResourceFactory(clazz), basePath);
    }

    @Override
    public void addSingletonResource(Object singleton) {
        this.addResourceFactory(new SingletonResource(singleton));
    }

    @Override
    public void addSingletonResource(Object singleton, String basePath) {
        this.addResourceFactory(new SingletonResource(singleton), basePath);
    }

    @Override
    public void addJndiResource(String jndiName) {
        this.addResourceFactory(new JndiResourceFactory(jndiName));
    }

    @Override
    public void addJndiResource(String jndiName, String basePath) {
        this.addResourceFactory(new JndiResourceFactory(jndiName), basePath);
    }

    public void addPerRequestResource(Class clazz) {
        this.addResourceFactory(new POJOResourceFactory(clazz));
    }

    @Override
    public void addResourceFactory(ResourceFactory ref) {
        this.addResourceFactory(ref, null);
    }

    @Override
    public void addResourceFactory(ResourceFactory ref, String base) {
        Class<?> clazz = ref.getScannableClass();
        Class restful = GetRestful.getRootResourceClass(clazz);
        if (restful == null) {
            String msg = "Class is not a root resource.  It, or one of its interfaces must be annotated with @Path: " + clazz.getName() + " implements: ";
            for (Class<?> intf : clazz.getInterfaces()) {
                msg = msg + " " + intf.getName();
            }
            throw new RuntimeException(msg);
        }
        this.addResourceFactory(ref, base, restful);
    }

    @Override
    public void addResourceFactory(ResourceFactory ref, String base, Class<?> clazz) {
        if (ref != null) {
            ref.registered(this.providerFactory.getInjectorFactory());
        }
        for (Method method : clazz.getMethods()) {
            this.processMethod(ref, base, clazz, method);
        }
    }

    protected void processMethod(ResourceFactory ref, String base, Class<?> clazz, Method method) {
        String pathExpression;
        Path path = method.getAnnotation(Path.class);
        Set<String> httpMethods = IsHttpMethod.getHttpMethods(method);
        if (path == null && httpMethods == null) {
            if (clazz.isInterface()) {
                return;
            }
            Method intfMethod = null;
            for (Class<?> intf : clazz.getInterfaces()) {
                try {
                    Method tmp = intf.getMethod(method.getName(), method.getParameterTypes());
                    if (intfMethod != null) {
                        throw new RuntimeException("Ambiguous inherited JAX-RS annotations applied to method: " + method);
                    }
                    path = tmp.getAnnotation(Path.class);
                    httpMethods = IsHttpMethod.getHttpMethods(tmp);
                    if (path == null && httpMethods == null) continue;
                    intfMethod = tmp;
                }
                catch (NoSuchMethodException ignored) {
                    // empty catch block
                }
            }
            if (intfMethod == null) {
                return;
            }
            this.processMethod(ref, base, clazz, intfMethod);
            return;
        }
        UriBuilderImpl builder = new UriBuilderImpl();
        if (base != null) {
            builder.path(base);
        }
        if (clazz.isAnnotationPresent(Path.class)) {
            builder.path(clazz);
        }
        if (path != null) {
            builder.path(method);
        }
        if ((pathExpression = builder.getPath()) == null) {
            pathExpression = "";
        }
        InjectorFactory injectorFactory = this.providerFactory.getInjectorFactory();
        if (httpMethods == null) {
            ResourceLocator locator = new ResourceLocator(ref, injectorFactory, this.providerFactory, clazz, method);
            this.rootSegment.addPath(pathExpression, locator);
        } else {
            ResourceMethod invoker = new ResourceMethod(clazz, method, injectorFactory, ref, this.providerFactory, httpMethods);
            this.rootSegment.addPath(pathExpression, invoker);
        }
        ++this.size;
    }

    public void removeRegistrations(Class clazz) {
        this.removeRegistrations(clazz, (String)null);
    }

    public void removeRegistrations(Class clazz, String base) {
        Class restful = GetRestful.getRootResourceClass(clazz);
        this.removeRegistration(base, restful);
    }

    private void removeRegistration(String base, Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            ResourceInvoker invoker;
            String pathExpression;
            Path path = method.getAnnotation(Path.class);
            Set<String> httpMethods = IsHttpMethod.getHttpMethods(method);
            if (path == null && httpMethods == null) continue;
            UriBuilderImpl builder = new UriBuilderImpl();
            if (base != null) {
                builder.path(base);
            }
            if (clazz.isAnnotationPresent(Path.class)) {
                builder.path(clazz);
            }
            if (path != null) {
                builder.path(method);
            }
            if ((pathExpression = builder.getPath()) == null) {
                pathExpression = "";
            }
            if ((invoker = this.rootSegment.removePath(pathExpression, method)) == null) continue;
            --this.size;
            if (!(invoker instanceof ResourceMethod)) continue;
            ((ResourceMethod)invoker).cleanup();
        }
    }

    public RootSegment getRoot() {
        return this.rootSegment;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public ResourceInvoker getResourceInvoker(HttpRequest request) {
        List matchedUris = request.getUri().getMatchedURIs(false);
        if (matchedUris == null || matchedUris.size() == 0) {
            return this.rootSegment.matchRoot(request);
        }
        String currentUri = (String)request.getUri().getMatchedURIs(false).get(0);
        return this.rootSegment.matchRoot(request, currentUri.length());
    }
}

