/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Path;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ProxyFactory;
import org.jboss.resteasy.client.core.ClientProxy;
import org.jboss.resteasy.client.core.MethodInvoker;
import org.jboss.resteasy.client.core.SubResourceInvoker;
import org.jboss.resteasy.client.core.extractors.DefaultEntityExtractorFactory;
import org.jboss.resteasy.client.core.extractors.EntityExtractorFactory;
import org.jboss.resteasy.client.core.marshallers.ResteasyClientProxy;
import org.jboss.resteasy.spi.ProviderFactoryDelegate;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.IsHttpMethod;

public class ProxyBuilder<T> {
    private final Class<T> iface;
    private final URI baseUri;
    private ClassLoader loader;
    private ClientExecutor executor = ClientRequest.getDefaultExecutor();
    private ResteasyProviderFactory providerFactory = ResteasyProviderFactory.getInstance();
    private EntityExtractorFactory extractorFactory = new DefaultEntityExtractorFactory();
    private Map<String, Object> requestAttributes = Collections.emptyMap();

    public static <T> ProxyBuilder<T> build(Class<T> iface, URI base) {
        return new ProxyBuilder<T>(iface, base);
    }

    public static <T> ProxyBuilder<T> build(Class<T> iface, String base) {
        return new ProxyBuilder<T>(iface, ProxyFactory.createUri(base));
    }

    private ProxyBuilder(Class<T> iface, URI base) {
        this.iface = iface;
        this.baseUri = base;
        this.loader = iface.getClassLoader();
    }

    public ProxyBuilder<T> classloader(ClassLoader cl) {
        this.loader = cl;
        return this;
    }

    public ProxyBuilder<T> executor(ClientExecutor exec) {
        this.executor = exec;
        return this;
    }

    public ProxyBuilder<T> providerFactory(ResteasyProviderFactory fact) {
        this.providerFactory = fact;
        return this;
    }

    public ProxyBuilder<T> extractorFactory(EntityExtractorFactory fact) {
        this.extractorFactory = fact;
        return this;
    }

    public ProxyBuilder<T> requestAttributes(Map<String, Object> attrs) {
        this.requestAttributes = attrs;
        return this;
    }

    public T now() {
        HashMap<Method, MethodInvoker> methodMap = new HashMap<Method, MethodInvoker>();
        if (this.providerFactory instanceof ProviderFactoryDelegate) {
            this.providerFactory = ((ProviderFactoryDelegate)((Object)this.providerFactory)).getDelegate();
        }
        for (Method method : this.iface.getMethods()) {
            Set<String> httpMethods = IsHttpMethod.getHttpMethods(method);
            MethodInvoker invoker = (httpMethods == null || httpMethods.size() == 0) && method.isAnnotationPresent(Path.class) && method.getReturnType().isInterface() ? new SubResourceInvoker(this.baseUri, method, this.providerFactory, this.executor, this.extractorFactory, this.loader) : ProxyFactory.createClientInvoker(this.iface, method, this.baseUri, this.executor, this.providerFactory, this.extractorFactory, this.requestAttributes);
            methodMap.put(method, invoker);
        }
        Class[] intfs = new Class[]{this.iface, ResteasyClientProxy.class};
        ClientProxy clientProxy = new ClientProxy(methodMap);
        clientProxy.setClazz(this.iface);
        return (T)Proxy.newProxyInstance(this.loader, intfs, (InvocationHandler)clientProxy);
    }
}

