/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.specimpl.PathSegmentImpl;
import org.jboss.resteasy.util.LocaleHelper;

@Provider
@PreMatching
public class AcceptHeaderByFileSuffixFilter
implements ContainerRequestFilter {
    public Map<String, MediaType> mediaTypeMappings = new HashMap<String, MediaType>();
    public Map<String, String> languageMappings = new HashMap<String, String>();

    public void setMediaTypeMappings(Map<String, MediaType> mediaTypeMappings) {
        this.mediaTypeMappings = mediaTypeMappings;
    }

    public void setLanguageMappings(Map<String, String> languageMappings) {
        this.languageMappings = languageMappings;
    }

    public Map<String, MediaType> getMediaTypeMappings() {
        return this.mediaTypeMappings;
    }

    public Map<String, String> getLanguageMappings() {
        return this.languageMappings;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        List<PathSegment> segments = null;
        if (this.mediaTypeMappings != null || this.languageMappings != null) {
            segments = this.process(requestContext, segments);
        }
        if (segments == null) {
            return;
        }
        StringBuilder preprocessedPath = new StringBuilder();
        for (PathSegment pathSegment : segments) {
            preprocessedPath.append("/").append(pathSegment.getPath());
        }
        URI requestUri = URI.create(preprocessedPath.toString());
        requestContext.setRequestUri(requestUri);
    }

    private List<PathSegment> process(ContainerRequestContext in, List<PathSegment> segments) {
        int index;
        String path = in.getUriInfo().getPath(false);
        int lastSegment = path.lastIndexOf(47);
        if (lastSegment < 0) {
            lastSegment = 0;
        }
        if ((index = path.indexOf(46, lastSegment)) < 0) {
            return null;
        }
        boolean preprocessed = false;
        String extension = path.substring(index + 1);
        String[] extensions = extension.split("\\.");
        StringBuilder rebuilt = new StringBuilder(path.substring(0, index));
        for (String ext : extensions) {
            Object match;
            if (this.mediaTypeMappings != null && (match = this.mediaTypeMappings.get(ext)) != null) {
                in.getAcceptableMediaTypes().add(0, match);
                preprocessed = true;
                continue;
            }
            if (this.languageMappings != null && (match = this.languageMappings.get(ext)) != null) {
                in.getAcceptableLanguages().add(LocaleHelper.extractLocale((String)match));
                preprocessed = true;
                continue;
            }
            rebuilt.append(".").append(ext);
        }
        if (preprocessed) {
            segments = PathSegmentImpl.parseSegments(rebuilt.toString(), false);
        }
        return segments;
    }
}

