/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.mock;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import org.jboss.resteasy.plugins.providers.FormUrlEncodedProvider;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyAsynchronousContext;
import org.jboss.resteasy.spi.ResteasyAsynchronousResponse;
import org.jboss.resteasy.spi.ResteasyUriInfo;
import org.jboss.resteasy.util.CaseInsensitiveMap;
import org.jboss.resteasy.util.Encode;
import org.jboss.resteasy.util.ReadFromStream;

public class MockHttpRequest
implements HttpRequest {
    protected ResteasyHttpHeaders httpHeaders;
    protected InputStream inputStream;
    protected ResteasyUriInfo uri;
    protected String httpMethod;
    protected MultivaluedMap<String, String> formParameters;
    protected MultivaluedMap<String, String> decodedFormParameters;
    protected Map<String, Object> attributes = new HashMap<String, Object>();
    protected ResteasyAsynchronousContext asynchronousContext;
    protected static final URI EMPTY_URI = URI.create("");

    protected MockHttpRequest() {
    }

    protected static MockHttpRequest initWithUri(String uri) throws URISyntaxException {
        URI absoluteUri = new URI(uri);
        URI baseUri = EMPTY_URI;
        return MockHttpRequest.initWithUri(absoluteUri, baseUri);
    }

    private static MockHttpRequest initWithUri(URI absoluteUri, URI baseUri) {
        if (baseUri == null) {
            baseUri = EMPTY_URI;
        }
        MockHttpRequest request = new MockHttpRequest();
        request.httpHeaders = new ResteasyHttpHeaders(new CaseInsensitiveMap<String>());
        URI absolutePath = UriBuilder.fromUri((URI)absoluteUri).replaceQuery(null).build(new Object[0]);
        URI relativeUri = baseUri.relativize(absoluteUri);
        relativeUri = UriBuilder.fromUri((String)relativeUri.getRawPath()).replaceQuery(absoluteUri.getRawQuery()).build(new Object[0]);
        request.uri = new ResteasyUriInfo(baseUri, relativeUri);
        return request;
    }

    public static MockHttpRequest create(String httpMethod, String uri) throws URISyntaxException {
        MockHttpRequest request = MockHttpRequest.initWithUri(uri);
        request.httpMethod = httpMethod;
        return request;
    }

    public static MockHttpRequest create(String httpMethod, URI uriObj, URI baseUri) {
        MockHttpRequest request = MockHttpRequest.initWithUri(uriObj, baseUri);
        request.httpMethod = httpMethod;
        return request;
    }

    public static MockHttpRequest options(String uri) throws URISyntaxException {
        MockHttpRequest request = MockHttpRequest.initWithUri(uri);
        request.httpMethod = "OPTIONS";
        return request;
    }

    public static MockHttpRequest get(String uri) throws URISyntaxException {
        MockHttpRequest request = MockHttpRequest.initWithUri(uri);
        request.httpMethod = "GET";
        return request;
    }

    public static MockHttpRequest post(String uri) throws URISyntaxException {
        MockHttpRequest request = MockHttpRequest.initWithUri(uri);
        request.httpMethod = "POST";
        return request;
    }

    public static MockHttpRequest put(String uri) throws URISyntaxException {
        MockHttpRequest request = MockHttpRequest.initWithUri(uri);
        request.httpMethod = "PUT";
        return request;
    }

    public static MockHttpRequest delete(String uri) throws URISyntaxException {
        MockHttpRequest request = MockHttpRequest.initWithUri(uri);
        request.httpMethod = "DELETE";
        return request;
    }

    public static MockHttpRequest head(String uri) throws URISyntaxException {
        MockHttpRequest request = MockHttpRequest.initWithUri(uri);
        request.httpMethod = "HEAD";
        return request;
    }

    public static MockHttpRequest deepCopy(HttpRequest request) throws IOException {
        MockHttpRequest mock = new MockHttpRequest();
        mock.uri = request.getUri();
        mock.httpHeaders = (ResteasyHttpHeaders)request.getHttpHeaders();
        mock.httpMethod = request.getHttpMethod();
        byte[] bytes = ReadFromStream.readFromStream(1024, request.getInputStream());
        mock.inputStream = new ByteArrayInputStream(bytes);
        return mock;
    }

    @Override
    public void setHttpMethod(String method) {
        this.httpMethod = method;
    }

    public ResteasyAsynchronousContext getAsynchronousContext() {
        return this.asynchronousContext;
    }

    public void setAsynchronousContext(ResteasyAsynchronousContext asynchronousContext) {
        this.asynchronousContext = asynchronousContext;
    }

    public MockHttpRequest header(String name, String value) {
        this.httpHeaders.getRequestHeaders().add((Object)name, (Object)value);
        return this;
    }

    public MockHttpRequest accept(List<MediaType> accepts) {
        for (MediaType accept : accepts) {
            this.accept(accept);
        }
        return this;
    }

    public MockHttpRequest accept(MediaType accept) {
        this.httpHeaders.getMutableHeaders().add((Object)"Accept", (Object)accept.toString());
        return this;
    }

    public MockHttpRequest accept(String type) {
        this.httpHeaders.getMutableHeaders().add((Object)"Accept", (Object)type);
        return this;
    }

    public MockHttpRequest language(String language) {
        this.httpHeaders.getMutableHeaders().add((Object)"Accept-Language", (Object)language);
        return this;
    }

    public MockHttpRequest cookie(String name, String value) {
        Cookie cookie = new Cookie(name, value);
        this.httpHeaders.getCookies().put(name, cookie);
        return this;
    }

    public MockHttpRequest contentType(String type) {
        this.httpHeaders.getMutableHeaders().add((Object)"Content-Type", (Object)type);
        return this;
    }

    public MockHttpRequest contentType(MediaType type) {
        if (type == null) {
            this.httpHeaders.getMutableHeaders().remove((Object)"Content-Type");
            return this;
        }
        this.httpHeaders.getMutableHeaders().add((Object)"Content-Type", (Object)type.toString());
        return this;
    }

    public MockHttpRequest content(byte[] bytes) {
        this.inputStream = new ByteArrayInputStream(bytes);
        return this;
    }

    public MockHttpRequest content(InputStream stream) {
        this.inputStream = stream;
        return this;
    }

    public MockHttpRequest addFormHeader(String name, String value) {
        if (this.decodedFormParameters == null) {
            this.decodedFormParameters = new MultivaluedMapImpl<String, String>();
            this.contentType("application/x-www-form-urlencoded");
        }
        this.decodedFormParameters.add((Object)name, (Object)value);
        return this;
    }

    @Override
    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    @Override
    public MultivaluedMap<String, String> getMutableHeaders() {
        return this.httpHeaders.getMutableHeaders();
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public void setInputStream(InputStream stream) {
        this.inputStream = stream;
    }

    @Override
    public ResteasyUriInfo getUri() {
        return this.uri;
    }

    @Override
    public String getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public MultivaluedMap<String, String> getFormParameters() {
        if (this.formParameters != null) {
            return this.formParameters;
        }
        if (this.decodedFormParameters != null) {
            this.formParameters = Encode.encode(this.decodedFormParameters);
            return this.formParameters;
        }
        if (this.getHttpHeaders().getMediaType().isCompatible(MediaType.valueOf((String)"application/x-www-form-urlencoded"))) {
            try {
                this.formParameters = FormUrlEncodedProvider.parseForm(this.getInputStream());
            }
            catch (IOException e) {
                throw new BadRequestException(e);
            }
        } else {
            throw new IllegalArgumentException("Request media type is not application/x-www-form-urlencoded");
        }
        return this.formParameters;
    }

    @Override
    public MultivaluedMap<String, String> getDecodedFormParameters() {
        if (this.decodedFormParameters != null) {
            return this.decodedFormParameters;
        }
        this.decodedFormParameters = Encode.decode(this.getFormParameters());
        return this.decodedFormParameters;
    }

    @Override
    public void setRequestUri(URI requestUri) throws IllegalStateException {
        this.uri = this.uri.setRequestUri(requestUri);
    }

    @Override
    public void setRequestUri(URI baseUri, URI requestUri) throws IllegalStateException {
        this.uri = new ResteasyUriInfo(baseUri.resolve(requestUri));
    }

    @Override
    public boolean isInitial() {
        return true;
    }

    public void initialRequestThreadFinished() {
    }

    @Override
    public Object getAttribute(String attribute) {
        return this.attributes.get(attribute);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    @Override
    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        Enumeration<String> en = new Enumeration<String>(){
            private Iterator<String> it;
            {
                this.it = MockHttpRequest.this.attributes.keySet().iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.it.hasNext();
            }

            @Override
            public String nextElement() {
                return this.it.next();
            }
        };
        return en;
    }

    @Override
    public ResteasyAsynchronousContext getAsyncContext() {
        if (this.asynchronousContext != null) {
            return this.asynchronousContext;
        }
        return new ResteasyAsynchronousContext(){

            @Override
            public boolean isSuspended() {
                return false;
            }

            @Override
            public ResteasyAsynchronousResponse getAsyncResponse() {
                return null;
            }

            @Override
            public AsyncResponse suspend() throws IllegalStateException {
                return null;
            }

            @Override
            public AsyncResponse suspend(long millis) throws IllegalStateException {
                return null;
            }

            @Override
            public AsyncResponse suspend(long time, TimeUnit unit) throws IllegalStateException {
                return null;
            }
        };
    }
}

