/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.specimpl;

import java.lang.annotation.Annotation;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.HeaderHelper;

public class ResponseBuilderImpl
extends Response.ResponseBuilder {
    protected Object entity;
    protected Annotation[] entityAnnotations;
    protected int status = -1;
    protected Headers<Object> metadata = new Headers();
    private static final SimpleDateFormat dateFormatRFC822 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);

    public Response build() {
        if (this.status == -1 && this.entity == null) {
            this.status = 204;
        } else if (this.status == -1) {
            this.status = 200;
        }
        return new BuiltResponse(this.status, this.metadata, this.entity, this.entityAnnotations);
    }

    public Response.ResponseBuilder clone() {
        ResponseBuilderImpl impl = new ResponseBuilderImpl();
        impl.metadata.putAll((Map)((Object)this.metadata));
        impl.entity = this.entity;
        impl.status = this.status;
        impl.entityAnnotations = this.entityAnnotations;
        return impl;
    }

    public Response.ResponseBuilder status(int status) {
        this.status = status;
        return this;
    }

    public Response.ResponseBuilder entity(Object entity) {
        this.entity = entity;
        return this;
    }

    public Response.ResponseBuilder entity(Object entity, Annotation[] annotations) {
        this.entity = entity;
        this.entityAnnotations = annotations;
        return this;
    }

    public Response.ResponseBuilder type(MediaType type) {
        if (type == null) {
            this.metadata.remove("Content-Type");
            return this;
        }
        this.metadata.putSingle("Content-Type", (Object)type);
        return this;
    }

    public Response.ResponseBuilder type(String type) {
        if (type == null) {
            this.metadata.remove("Content-Type");
            return this;
        }
        this.metadata.putSingle("Content-Type", (Object)type);
        return this;
    }

    public Response.ResponseBuilder variant(Variant variant) {
        if (variant == null) {
            this.type((String)null);
            this.language((String)null);
            this.metadata.remove("Content-Encoding");
            return this;
        }
        this.type(variant.getMediaType());
        this.language(variant.getLanguage());
        if (variant.getEncoding() != null) {
            this.metadata.putSingle("Content-Encoding", (Object)variant.getEncoding());
        } else {
            this.metadata.remove("Content-Encoding");
        }
        return this;
    }

    public Response.ResponseBuilder variants(List<Variant> variants) {
        if (variants == null) {
            this.metadata.remove("Vary");
            return this;
        }
        String vary = ResponseBuilderImpl.createVaryHeader(variants);
        this.metadata.putSingle("Vary", (Object)vary);
        return this;
    }

    public static String createVaryHeader(List<Variant> variants) {
        boolean accept = false;
        boolean acceptLanguage = false;
        boolean acceptEncoding = false;
        for (Variant variant : variants) {
            if (variant.getMediaType() != null) {
                accept = true;
            }
            if (variant.getLanguage() != null) {
                acceptLanguage = true;
            }
            if (variant.getEncoding() == null) continue;
            acceptEncoding = true;
        }
        String vary = null;
        if (accept) {
            vary = "Accept";
        }
        if (acceptLanguage) {
            vary = vary == null ? "Accept-Language" : vary + ", Accept-Language";
        }
        if (acceptEncoding) {
            vary = vary == null ? "Accept-Encoding" : vary + ", Accept-Encoding";
        }
        return vary;
    }

    public Response.ResponseBuilder language(String language) {
        if (language == null) {
            this.metadata.remove("Content-Language");
            return this;
        }
        this.metadata.putSingle("Content-Language", (Object)language);
        return this;
    }

    public Response.ResponseBuilder location(URI location) {
        if (location == null) {
            this.metadata.remove("Location");
            return this;
        }
        if (!location.isAbsolute() && ResteasyProviderFactory.getContextData(HttpRequest.class) != null) {
            String path = location.toString();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            URI baseUri = ResteasyProviderFactory.getContextData(HttpRequest.class).getUri().getBaseUri();
            location = baseUri.resolve(path);
        }
        this.metadata.putSingle("Location", (Object)location);
        return this;
    }

    public Response.ResponseBuilder contentLocation(URI location) {
        if (location == null) {
            this.metadata.remove("Content-Location");
            return this;
        }
        if (!location.isAbsolute() && ResteasyProviderFactory.getContextData(HttpRequest.class) != null) {
            String path = location.toString();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            URI baseUri = ResteasyProviderFactory.getContextData(HttpRequest.class).getUri().getBaseUri();
            location = baseUri.resolve(path);
        }
        this.metadata.putSingle("Content-Location", (Object)location);
        return this;
    }

    public Response.ResponseBuilder tag(EntityTag tag) {
        if (tag == null) {
            this.metadata.remove("ETag");
            return this;
        }
        this.metadata.putSingle("ETag", (Object)tag);
        return this;
    }

    public Response.ResponseBuilder tag(String tag) {
        if (tag == null) {
            this.metadata.remove("ETag");
            return this;
        }
        this.metadata.putSingle("ETag", (Object)tag);
        return this;
    }

    public Response.ResponseBuilder lastModified(Date lastModified) {
        if (lastModified == null) {
            this.metadata.remove("Last-Modified");
            return this;
        }
        this.metadata.putSingle("Last-Modified", (Object)lastModified);
        return this;
    }

    public Response.ResponseBuilder cacheControl(CacheControl cacheControl) {
        if (cacheControl == null) {
            this.metadata.remove("Cache-Control");
            return this;
        }
        this.metadata.putSingle("Cache-Control", (Object)cacheControl);
        return this;
    }

    public Response.ResponseBuilder header(String name, Object value) {
        if (value == null) {
            this.metadata.remove(name);
            return this;
        }
        this.metadata.add(name, value);
        return this;
    }

    public Response.ResponseBuilder cookie(NewCookie ... cookies) {
        if (cookies == null) {
            this.metadata.remove("Set-Cookie");
            return this;
        }
        for (NewCookie cookie : cookies) {
            this.metadata.add("Set-Cookie", (Object)cookie);
        }
        return this;
    }

    public Response.ResponseBuilder language(Locale language) {
        if (language == null) {
            this.metadata.remove("Content-Language");
            return this;
        }
        this.metadata.putSingle("Content-Language", (Object)language);
        return this;
    }

    public Response.ResponseBuilder expires(Date expires) {
        if (expires == null) {
            this.metadata.remove("Expires");
            return this;
        }
        this.metadata.putSingle("Expires", (Object)dateFormatRFC822.format(expires));
        return this;
    }

    public Response.ResponseBuilder allow(String ... methods) {
        if (methods == null) {
            return this.allow((Set<String>)null);
        }
        HashSet<String> set = new HashSet<String>();
        for (String m : methods) {
            set.add(m);
        }
        return this.allow(set);
    }

    public Response.ResponseBuilder allow(Set<String> methods) {
        HeaderHelper.setAllow(this.metadata, methods);
        return this;
    }

    public Response.ResponseBuilder encoding(String encoding) {
        if (encoding == null) {
            this.metadata.remove("Content-Encoding");
            return this;
        }
        this.metadata.putSingle("Content-Encoding", (Object)encoding);
        return this;
    }

    public Response.ResponseBuilder variants(Variant ... variants) {
        return this.variants(Arrays.asList(variants));
    }

    public Response.ResponseBuilder links(Link ... links) {
        this.metadata.remove("Link");
        for (Link link : links) {
            this.metadata.add("Link", (Object)link);
        }
        return this;
    }

    public Response.ResponseBuilder link(URI uri, String rel) {
        Link link = Link.fromUri((URI)uri).rel(rel).build(new Object[0]);
        this.metadata.add("Link", (Object)link);
        return this;
    }

    public Response.ResponseBuilder link(String uri, String rel) {
        Link link = Link.fromUri((String)uri).rel(rel).build(new Object[0]);
        this.metadata.add("Link", (Object)link);
        return this;
    }

    public Response.ResponseBuilder replaceAll(MultivaluedMap<String, Object> headers) {
        this.metadata.clear();
        if (headers == null) {
            return this;
        }
        this.metadata.putAll((Map)headers);
        return this;
    }

    static {
        dateFormatRFC822.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

