/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.core.executors;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.BaseClientResponse;
import org.jboss.resteasy.client.core.SelfExpandingBufferredInputStream;
import org.jboss.resteasy.client.exception.mapper.ApacheHttpClient4ExceptionMapper;
import org.jboss.resteasy.client.exception.mapper.ClientExceptionMapper;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.CaseInsensitiveMap;
import org.jboss.resteasy.util.Types;

public class ApacheHttpClient4Executor
implements ClientExecutor {
    public static final String BYTE_MEMORY_UNIT = "BY";
    public static final String KILOBYTE_MEMORY_UNIT = "KB";
    public static final String MEGABYTE_MEMORY_UNIT = "MB";
    public static final String GIGABYTE_MEMORY_UNIT = "GB";
    private static String processId = null;
    protected HttpClient httpClient;
    protected boolean createdHttpClient;
    protected HttpContext httpContext;
    protected boolean closed;
    private int fileUploadInMemoryThresholdLimit = 1;
    private MemoryUnit fileUploadMemoryUnit = MemoryUnit.MB;
    private File fileUploadTempFileDir = new File(System.getProperty("java.io.tmpdir"));
    private static final Logger LOGGER;

    private static synchronized void checkClientExceptionMapper() {
        if (ResteasyProviderFactory.getInstance().getClientExceptionMapper(Exception.class) == null) {
            Type exceptionType = Types.getActualTypeArgumentsOfAnInterface(ApacheHttpClient4ExceptionMapper.class, ClientExceptionMapper.class)[0];
            ResteasyProviderFactory.getInstance().addClientExceptionMapper(new ApacheHttpClient4ExceptionMapper(), exceptionType);
        }
    }

    public ApacheHttpClient4Executor() {
        this.httpClient = new DefaultHttpClient();
        this.createdHttpClient = true;
        ApacheHttpClient4Executor.checkClientExceptionMapper();
    }

    public ApacheHttpClient4Executor(HttpClient httpClient) {
        this.httpClient = httpClient;
        ApacheHttpClient4Executor.checkClientExceptionMapper();
    }

    public ApacheHttpClient4Executor(HttpClient httpClient, HttpContext httpContext) {
        this.httpClient = httpClient;
        this.httpContext = httpContext;
        ApacheHttpClient4Executor.checkClientExceptionMapper();
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public static CaseInsensitiveMap<String> extractHeaders(HttpResponse response) {
        CaseInsensitiveMap<String> headers = new CaseInsensitiveMap<String>();
        for (Header header : response.getAllHeaders()) {
            headers.add(header.getName(), header.getValue());
        }
        return headers;
    }

    @Override
    public ClientRequest createRequest(String uriTemplate) {
        return new ClientRequest(uriTemplate, (ClientExecutor)this);
    }

    @Override
    public ClientRequest createRequest(UriBuilder uriBuilder) {
        return new ClientRequest(uriBuilder, (ClientExecutor)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientResponse execute(ClientRequest request) throws Exception {
        String uri = request.getUri();
        HttpRequestBase httpMethod = this.createHttpMethod(uri, request.getHttpMethod());
        try {
            this.loadHttpMethod(request, httpMethod);
            final HttpResponse res = this.httpClient.execute((HttpUriRequest)httpMethod, this.httpContext);
            BaseClientResponse response = new BaseClientResponse(null, this);
            BaseClientResponse.BaseClientResponseStreamFactory sf = new BaseClientResponse.BaseClientResponseStreamFactory(){
                InputStream stream;

                @Override
                public InputStream getInputStream() throws IOException {
                    if (this.stream == null) {
                        HttpEntity entity = res.getEntity();
                        if (entity == null) {
                            return null;
                        }
                        this.stream = new SelfExpandingBufferredInputStream(entity.getContent());
                    }
                    return this.stream;
                }

                @Override
                public void performReleaseConnection() {
                    try {
                        if (this.stream != null) {
                            this.stream.close();
                        } else {
                            InputStream is = this.getInputStream();
                            if (is != null) {
                                is.close();
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            response.setStreamFactory(sf);
            response.setAttributes(request.getAttributes());
            response.setStatus(res.getStatusLine().getStatusCode());
            response.setHeaders(ApacheHttpClient4Executor.extractHeaders(res));
            response.setProviderFactory(request.getProviderFactory());
            BaseClientResponse baseClientResponse = response;
            return baseClientResponse;
        }
        finally {
            this.cleanUpAfterExecute(httpMethod);
        }
    }

    protected void cleanUpAfterExecute(HttpRequestBase httpMethod) {
        HttpPost postMethod;
        HttpEntity entity;
        if (httpMethod != null && httpMethod instanceof HttpPost && (entity = (postMethod = (HttpPost)httpMethod).getEntity()) != null && entity instanceof FileExposingFileEntity) {
            File tempRequestFile = ((FileExposingFileEntity)entity).getFile();
            try {
                boolean isDeleted = tempRequestFile.delete();
                if (!isDeleted) {
                    this.handleFileNotDeletedError(tempRequestFile, null);
                }
            }
            catch (Exception ex) {
                this.handleFileNotDeletedError(tempRequestFile, ex);
            }
        }
    }

    private HttpRequestBase createHttpMethod(String url, String restVerb) {
        if ("GET".equals(restVerb)) {
            return new HttpGet(url);
        }
        if ("POST".equals(restVerb)) {
            return new HttpPost(url);
        }
        final String verb = restVerb;
        return new HttpPost(url){

            public String getMethod() {
                return verb;
            }
        };
    }

    public void loadHttpMethod(ClientRequest request, HttpRequestBase httpMethod) throws Exception {
        if (httpMethod instanceof HttpGet && request.followRedirects()) {
            HttpClientParams.setRedirecting((HttpParams)httpMethod.getParams(), (boolean)true);
        } else {
            HttpClientParams.setRedirecting((HttpParams)httpMethod.getParams(), (boolean)false);
        }
        if (request.getBody() != null && !request.getFormParameters().isEmpty()) {
            throw new RuntimeException("You cannot send both form parameters and an entity body");
        }
        if (!request.getFormParameters().isEmpty()) {
            this.commitHeaders(request, httpMethod);
            HttpPost post = (HttpPost)httpMethod;
            ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
            for (Map.Entry formParam : request.getFormParameters().entrySet()) {
                List values = (List)formParam.getValue();
                for (String value : values) {
                    formparams.add(new BasicNameValuePair((String)formParam.getKey(), value));
                }
            }
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(formparams, "UTF-8");
            post.setEntity((HttpEntity)entity);
        } else if (request.getBody() != null) {
            if (httpMethod instanceof HttpGet) {
                throw new RuntimeException("A GET request cannot have a body.");
            }
            try {
                HttpEntity entity = this.buildEntity(request);
                HttpPost post = (HttpPost)httpMethod;
                this.commitHeaders(request, httpMethod);
                post.setEntity(entity);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.commitHeaders(request, httpMethod);
        }
    }

    protected HttpEntity buildEntity(ClientRequest request) throws IOException {
        FileExposingFileEntity entityToBuild = null;
        DeferredFileOutputStream memoryManagedOutStream = this.writeRequestBodyToOutputStream(request);
        if (memoryManagedOutStream.isInMemory()) {
            ByteArrayEntity entityToBuildByteArray = new ByteArrayEntity(memoryManagedOutStream.getData());
            entityToBuildByteArray.setContentType((Header)new BasicHeader("Content-Type", request.getBodyContentType().toString()));
            entityToBuild = entityToBuildByteArray;
        } else {
            File requestBodyFile = memoryManagedOutStream.getFile();
            requestBodyFile.deleteOnExit();
            entityToBuild = new FileExposingFileEntity(memoryManagedOutStream.getFile(), request.getBodyContentType().toString());
        }
        return entityToBuild;
    }

    private DeferredFileOutputStream writeRequestBodyToOutputStream(ClientRequest request) throws IOException {
        DeferredFileOutputStream memoryManagedOutStream = new DeferredFileOutputStream(this.fileUploadInMemoryThresholdLimit * this.getMemoryUnitMultiplier(), this.getTempfilePrefix(), ".tmp", this.fileUploadTempFileDir);
        request.writeRequestBody(request.getHeadersAsObjects(), (OutputStream)memoryManagedOutStream);
        memoryManagedOutStream.close();
        return memoryManagedOutStream;
    }

    private int getMemoryUnitMultiplier() {
        switch (this.fileUploadMemoryUnit) {
            case BY: {
                return 1;
            }
            case KB: {
                return 1024;
            }
            case MB: {
                return 0x100000;
            }
            case GB: {
                return 0x40000000;
            }
        }
        return 1;
    }

    protected String getTempfilePrefix() {
        return processId;
    }

    private void handleFileNotDeletedError(File tempRequestFile, Exception ex) {
        if (LOGGER.isLoggable(Level.SEVERE)) {
            LOGGER.log(Level.SEVERE, "Could not delete file' " + tempRequestFile.getAbsolutePath() + "' for request: ", ex);
        }
    }

    void setHttpClient(HttpClient pHttpClient) {
        this.httpClient = pHttpClient;
    }

    public void setFileUploadInMemoryThresholdLimit(int pInMemoryThresholdLimit) {
        this.fileUploadInMemoryThresholdLimit = pInMemoryThresholdLimit;
    }

    public void setFileUploadTempFileDir(File pTempFileDir) {
        this.fileUploadTempFileDir = pTempFileDir;
    }

    public void setFileUploadMemoryUnit(String pMemoryUnit) {
        this.fileUploadMemoryUnit = MemoryUnit.valueOf(pMemoryUnit);
    }

    public void commitHeaders(ClientRequest request, HttpRequestBase httpMethod) {
        MultivaluedMap<String, String> headers = request.getHeaders();
        for (Map.Entry header : headers.entrySet()) {
            List values = (List)header.getValue();
            for (String value : values) {
                httpMethod.addHeader((String)header.getKey(), value);
            }
        }
    }

    @Override
    public void close() {
        ClientConnectionManager manager;
        if (this.closed) {
            return;
        }
        if (this.createdHttpClient && this.httpClient != null && (manager = this.httpClient.getConnectionManager()) != null) {
            manager.shutdown();
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    static {
        processId = ManagementFactory.getRuntimeMXBean().getName().replaceAll("[^0-9a-zA-Z]", "");
        LOGGER = Logger.getLogger(ApacheHttpClient4Executor.class.getName());
    }

    private static enum MemoryUnit {
        BY,
        KB,
        MB,
        GB;

    }

    private static class FileExposingFileEntity
    extends FileEntity {
        public FileExposingFileEntity(File pFile, String pContentType) {
            super(pFile, pContentType);
        }

        File getFile() {
            return this.file;
        }
    }

    static class ResponseStream
    extends SelfExpandingBufferredInputStream {
        BaseClientResponse response;

        public ResponseStream(InputStream in, BaseClientResponse response) {
            super(in);
            this.response = response;
        }

        @Override
        public synchronized void close() throws IOException {
            super.close();
            this.response = null;
        }
    }
}

