/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.api.validation;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.resteasy.api.validation.ResteasyConstraintViolation;
import org.jboss.resteasy.api.validation.ResteasyViolationException;

@XmlRootElement(name="violationReport")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ViolationReport {
    private String exception;
    private ArrayList<ResteasyConstraintViolation> fieldViolations = new ArrayList();
    private ArrayList<ResteasyConstraintViolation> propertyViolations = new ArrayList();
    private ArrayList<ResteasyConstraintViolation> classViolations = new ArrayList();
    private ArrayList<ResteasyConstraintViolation> parameterViolations = new ArrayList();
    private ArrayList<ResteasyConstraintViolation> returnValueViolations = new ArrayList();

    public ViolationReport(ResteasyViolationException exception) {
        Exception e = exception.getException();
        if (e != null) {
            this.exception = e.toString();
        }
        this.fieldViolations = new ArrayList<ResteasyConstraintViolation>(exception.getFieldViolations());
        this.propertyViolations = new ArrayList<ResteasyConstraintViolation>(exception.getPropertyViolations());
        this.classViolations = new ArrayList<ResteasyConstraintViolation>(exception.getClassViolations());
        this.parameterViolations = new ArrayList<ResteasyConstraintViolation>(exception.getParameterViolations());
        this.returnValueViolations = new ArrayList<ResteasyConstraintViolation>(exception.getReturnValueViolations());
    }

    public ViolationReport(String s) {
        this(new ResteasyViolationException(s));
    }

    public ViolationReport() {
    }

    public String getException() {
        return this.exception;
    }

    public ArrayList<ResteasyConstraintViolation> getFieldViolations() {
        return this.fieldViolations;
    }

    public ArrayList<ResteasyConstraintViolation> getPropertyViolations() {
        return this.propertyViolations;
    }

    public ArrayList<ResteasyConstraintViolation> getClassViolations() {
        return this.classViolations;
    }

    public ArrayList<ResteasyConstraintViolation> getParameterViolations() {
        return this.parameterViolations;
    }

    public ArrayList<ResteasyConstraintViolation> getReturnValueViolations() {
        return this.returnValueViolations;
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    public void setFieldViolations(ArrayList<ResteasyConstraintViolation> fieldViolations) {
        this.fieldViolations = fieldViolations;
    }

    public void setPropertyViolations(ArrayList<ResteasyConstraintViolation> propertyViolations) {
        this.propertyViolations = propertyViolations;
    }

    public void setClassViolations(ArrayList<ResteasyConstraintViolation> classViolations) {
        this.classViolations = classViolations;
    }

    public void setParameterViolations(ArrayList<ResteasyConstraintViolation> parameterViolations) {
        this.parameterViolations = parameterViolations;
    }

    public void setReturnValueViolations(ArrayList<ResteasyConstraintViolation> returnValueViolations) {
        this.returnValueViolations = returnValueViolations;
    }
}

