/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.exception;

import javax.ws.rs.BadRequestException;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.RedirectionException;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.exception.ResteasyBadRequestException;
import org.jboss.resteasy.client.exception.ResteasyClientErrorException;
import org.jboss.resteasy.client.exception.ResteasyForbiddenException;
import org.jboss.resteasy.client.exception.ResteasyInternalServerErrorException;
import org.jboss.resteasy.client.exception.ResteasyNotAcceptableException;
import org.jboss.resteasy.client.exception.ResteasyNotAllowedException;
import org.jboss.resteasy.client.exception.ResteasyNotAuthorizedException;
import org.jboss.resteasy.client.exception.ResteasyNotFoundException;
import org.jboss.resteasy.client.exception.ResteasyNotSupportedException;
import org.jboss.resteasy.client.exception.ResteasyRedirectionException;
import org.jboss.resteasy.client.exception.ResteasyServerErrorException;
import org.jboss.resteasy.client.exception.ResteasyServiceUnavailableException;
import org.jboss.resteasy.client.exception.ResteasyWebApplicationException;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.microprofile.config.ResteasyConfig;
import org.jboss.resteasy.microprofile.config.ResteasyConfigFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public interface WebApplicationExceptionWrapper<T extends WebApplicationException> {
    public static WebApplicationException wrap(WebApplicationException e) {
        boolean serverSide;
        ResteasyConfig config = ResteasyConfigFactory.getConfig();
        boolean originalBehavior = Boolean.parseBoolean(config.getValue("resteasy.original.webapplicationexception.behavior", ResteasyConfig.SOURCE.SERVLET_CONTEXT, "false"));
        boolean bl = serverSide = ResteasyProviderFactory.searchContextData(Dispatcher.class) != null;
        if (originalBehavior || !serverSide) {
            return e;
        }
        if (e instanceof WebApplicationExceptionWrapper) {
            return e;
        }
        if (e instanceof BadRequestException) {
            return new ResteasyBadRequestException((BadRequestException)e);
        }
        if (e instanceof NotAuthorizedException) {
            return new ResteasyNotAuthorizedException((NotAuthorizedException)e);
        }
        if (e instanceof ForbiddenException) {
            return new ResteasyForbiddenException((ForbiddenException)e);
        }
        if (e instanceof NotFoundException) {
            return new ResteasyNotFoundException((NotFoundException)e);
        }
        if (e instanceof NotAllowedException) {
            return new ResteasyNotAllowedException((NotAllowedException)e);
        }
        if (e instanceof NotAcceptableException) {
            return new ResteasyNotAcceptableException((NotAcceptableException)e);
        }
        if (e instanceof NotSupportedException) {
            return new ResteasyNotSupportedException((NotSupportedException)e);
        }
        if (e instanceof InternalServerErrorException) {
            return new ResteasyInternalServerErrorException((InternalServerErrorException)e);
        }
        if (e instanceof ServiceUnavailableException) {
            return new ResteasyServiceUnavailableException((ServiceUnavailableException)e);
        }
        if (e instanceof ClientErrorException) {
            return new ResteasyClientErrorException((ClientErrorException)e);
        }
        if (e instanceof ServerErrorException) {
            return new ResteasyServerErrorException((ServerErrorException)e);
        }
        if (e instanceof RedirectionException) {
            return new ResteasyRedirectionException((RedirectionException)e);
        }
        return new ResteasyWebApplicationException(e);
    }

    public static WebApplicationException unwrap(WebApplicationException e) {
        if (e instanceof WebApplicationExceptionWrapper) {
            return ((WebApplicationExceptionWrapper)((Object)e)).unwrap();
        }
        return e;
    }

    public static Response sanitize(Response response) {
        MediaType mediaType = response.getMediaType();
        if (mediaType == null) {
            mediaType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        return Response.status((int)response.getStatus()).allow(response.getAllowedMethods()).type(mediaType).build();
    }

    public T unwrap();
}

