package org.jboss.resteasy.resteasy_jaxrs.i18n;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import javax.ws.rs.core.MediaType;
import java.lang.Class;
import java.lang.String;
import org.jboss.logging.Logger;
import java.net.URL;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2021-03-04T14:13:10-0500")
public class LogMessages_$logger extends DelegatingBasicLogger implements LogMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = LogMessages_$logger.class.getName();
    public LogMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void errorResumingFailedAsynchOperation(final Throwable cause) {
        super.log.logv(FQCN, ERROR, cause, errorResumingFailedAsynchOperation$str());
    }
    protected String errorResumingFailedAsynchOperation$str() {
        return "RESTEASY002000: Error resuming failed async operation";
    }
    @Override
    public final void failedExecutingError(final String method, final String path, final Throwable cause) {
        super.log.logv(FQCN, ERROR, cause, failedExecutingError$str(), method, path);
    }
    protected String failedExecutingError$str() {
        return "RESTEASY002005: Failed executing {0} {1}";
    }
    @Override
    public final void failedToExecute(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, failedToExecute$str());
    }
    protected String failedToExecute$str() {
        return "RESTEASY002010: Failed to execute";
    }
    @Override
    public final void failedToInvokeAsynchronously(final Throwable ignored) {
        super.log.logf(FQCN, ERROR, ignored, failedToInvokeAsynchronously$str());
    }
    protected String failedToInvokeAsynchronously$str() {
        return "RESTEASY002015: Failed to invoke asynchronously";
    }
    @Override
    public final void unhandledAsynchronousException(final Throwable ignored) {
        super.log.logv(FQCN, ERROR, ignored, unhandledAsynchronousException$str());
    }
    protected String unhandledAsynchronousException$str() {
        return "RESTEASY002020: Unhandled asynchronous exception, sending back 500";
    }
    @Override
    public final void unknownException(final String method, final String path, final Throwable cause) {
        super.log.logv(FQCN, ERROR, cause, unknownException$str(), method, path);
    }
    protected String unknownException$str() {
        return "RESTEASY002025: Unknown exception while executing {0} {1}";
    }
    @Override
    public final void failedToWriteSseEvent(final String event, final Throwable cause) {
        super.log.logv(FQCN, DEBUG, cause, failedToWriteSseEvent$str(), event);
    }
    protected String failedToWriteSseEvent$str() {
        return "RESTEASY002030: Failed to write event {0}";
    }
    @Override
    public final void acceptExtensionsNotSupported() {
        super.log.logf(FQCN, WARN, null, acceptExtensionsNotSupported$str());
    }
    protected String acceptExtensionsNotSupported$str() {
        return "RESTEASY002100: Accept extensions not supported.";
    }
    @Override
    public final void ambiguousConstructorsFound(final Class<?> clazz) {
        super.log.logf(FQCN, WARN, null, ambiguousConstructorsFound$str(), clazz);
    }
    protected String ambiguousConstructorsFound$str() {
        return "RESTEASY002105: Ambiguity constructors are found in %s. More details please refer to http://jsr311.java.net/nonav/releases/1.1/spec/spec.html";
    }
    @Override
    public final void attemptingToRegisterEmptyContracts(final String className) {
        super.log.logf(FQCN, WARN, null, attemptingToRegisterEmptyContracts$str(), className);
    }
    protected String attemptingToRegisterEmptyContracts$str() {
        return "RESTEASY002110: Attempting to register empty contracts for %s";
    }
    @Override
    public final void attemptingToRegisterUnassignableContract(final String className) {
        super.log.logf(FQCN, WARN, null, attemptingToRegisterUnassignableContract$str(), className);
    }
    protected String attemptingToRegisterUnassignableContract$str() {
        return "RESTEASY002115: Attempting to register unassignable contract for %s";
    }
    @Override
    public final void charsetUnavailable(final String charset) {
        super.log.logf(FQCN, WARN, null, charsetUnavailable$str(), charset);
    }
    protected String charsetUnavailable$str() {
        return "RESTEASY002117: Charset %s unavailable.";
    }
    @Override
    public final void classNotFoundException(final String line, final URL url, final Throwable cause) {
        super.log.logv(FQCN, WARN, cause, classNotFoundException$str(), line, url);
    }
    protected String classNotFoundException$str() {
        return "RESTEASY002120: ClassNotFoundException: Unable to load builtin provider {0} from {1}";
    }
    @Override
    public final void couldNotBindToDirectory(final String directory) {
        super.log.logf(FQCN, WARN, null, couldNotBindToDirectory$str(), directory);
    }
    protected String couldNotBindToDirectory$str() {
        return "RESTEASY002123: Could not bind to specified download directory %s so will use temp dir.";
    }
    @Override
    public final void couldNotDeleteFile(final String path, final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, couldNotDeleteFile$str(), path);
    }
    protected String couldNotDeleteFile$str() {
        return "RESTEASY002125: Marking file '%s' to be deleted, as it could not be deleted while processing request:";
    }
    @Override
    public final void failedToParseRequest(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, failedToParseRequest$str());
    }
    protected String failedToParseRequest$str() {
        return "RESTEASY002130: Failed to parse request.";
    }
    @Override
    public final void ignoringUnsupportedLocale(final String locale) {
        super.log.logf(FQCN, WARN, null, ignoringUnsupportedLocale$str(), locale);
    }
    protected String ignoringUnsupportedLocale$str() {
        return "RESTEASY002135: Ignoring unsupported locale: %s";
    }
    @Override
    public final void invalidFormat(final String parameterName, final String defaultValue) {
        super.log.logv(FQCN, WARN, null, invalidFormat$str(), parameterName, defaultValue);
    }
    protected String invalidFormat$str() {
        return "RESTEASY002137: Invalid format for {0}, using default value {1}";
    }
    @Override
    public final void JAXRSAnnotationsFoundAtNonPublicMethod(final String className, final String method) {
        super.log.logv(FQCN, WARN, null, JAXRSAnnotationsFoundAtNonPublicMethod$str(), className, method);
    }
    protected String JAXRSAnnotationsFoundAtNonPublicMethod$str() {
        return "RESTEASY002140: JAX-RS annotations found at non-public method: {0}.{1}(); Only public methods may be exposed as resource methods.";
    }
    @Override
    public final void multipleMethodsMatch(final String request, final String[] methods) {
        super.log.logv(FQCN, WARN, null, multipleMethodsMatch$str(), request, java.util.Arrays.toString(methods));
    }
    protected String multipleMethodsMatch$str() {
        return "RESTEASY002142: Multiple resource methods match request {0}. Selecting one. Matching methods: {1}";
    }
    @Override
    public final void noClassDefFoundErrorError(final String line, final URL url, final Throwable cause) {
        super.log.logv(FQCN, WARN, cause, noClassDefFoundErrorError$str(), line, url);
    }
    protected String noClassDefFoundErrorError$str() {
        return "RESTEASY002145: NoClassDefFoundError: Unable to load builtin provider {0} from {1}";
    }
    @Override
    public final void noLongerSupported(final String param) {
        super.log.logf(FQCN, WARN, null, noLongerSupported$str(), param);
    }
    protected String noLongerSupported$str() {
        return "RESTEASY002150: %s is no longer supported.  Use a servlet 3.0 container and the ResteasyServletInitializer";
    }
    @Override
    public final void providerClassAlreadyRegistered(final String className) {
        super.log.logv(FQCN, WARN, null, providerClassAlreadyRegistered$str(), className);
    }
    protected String providerClassAlreadyRegistered$str() {
        return "RESTEASY002155: Provider class {0} is already registered.  2nd registration is being ignored.";
    }
    @Override
    public final void providerInstanceAlreadyRegistered(final String className) {
        super.log.logv(FQCN, WARN, null, providerInstanceAlreadyRegistered$str(), className);
    }
    protected String providerInstanceAlreadyRegistered$str() {
        return "RESTEASY002160: Provider instance {0} is already registered.  2nd registration is being ignored.";
    }
    @Override
    public final void noValueOfMethodAvailable(final String className) {
        super.log.logf(FQCN, WARN, null, noValueOfMethodAvailable$str(), className);
    }
    protected String noValueOfMethodAvailable$str() {
        return "RESTEASY002165: No valueOf() method available for %s, trying constructor...";
    }
    @Override
    public final void readerNotFound(final MediaType mediaType, final String[] availableTypes) {
        super.log.logv(FQCN, WARN, null, readerNotFound$str(), mediaType, java.util.Arrays.toString(availableTypes));
    }
    protected String readerNotFound$str() {
        return "RESTEASY002170: A reader for {0} was not found. This provider is currently configured to handle only {1}";
    }
    @Override
    public final void singletonClassAlreadyDeployed(final String type, final String className) {
        super.log.logv(FQCN, WARN, null, singletonClassAlreadyDeployed$str(), type, className);
    }
    protected String singletonClassAlreadyDeployed$str() {
        return "RESTEASY002172: Singleton {0} object class {1} already deployed. Singleton ignored.";
    }
    @Override
    public final void useOfApplicationClass(final String className) {
        super.log.logf(FQCN, WARN, null, useOfApplicationClass$str(), className);
    }
    protected String useOfApplicationClass$str() {
        return "RESTEASY002175: The use of %s is deprecated, please use javax.ws.rs.Application as a context-param instead";
    }
    @Override
    public final void skipIllegalField(final String filed, final String value) {
        super.log.logf(FQCN, WARN, null, skipIllegalField$str(), filed, value);
    }
    protected String skipIllegalField$str() {
        return "RESTEASY002180: Skip illegal field [%s] in value: [%s]";
    }
    @Override
    public final void skipUnkownFiled(final String filed) {
        super.log.logf(FQCN, WARN, null, skipUnkownFiled$str(), filed);
    }
    protected String skipUnkownFiled$str() {
        return "RESTEASY002185: Skip unknown field [%s]";
    }
    @Override
    public final void failedToSetRequestAsync() {
        super.log.logf(FQCN, WARN, null, failedToSetRequestAsync$str());
    }
    protected String failedToSetRequestAsync$str() {
        return "RESTEASY002186: Failed to set servlet request into asynchronous mode, server sent events may not work";
    }
    @Override
    public final void warningPreMatchingSupport(final String clazzname) {
        super.log.logf(FQCN, WARN, null, warningPreMatchingSupport$str(), clazzname);
    }
    protected String warningPreMatchingSupport$str() {
        return "RESTEASY002190: Annotation, @PreMaching, not valid on ClientRequestFilter implementation, [%s].  Annotation is being ignored.";
    }
    @Override
    public final void uriAmbiguity(final String path, final String methodList) {
        super.log.logf(FQCN, WARN, null, uriAmbiguity$str(), path, methodList);
    }
    protected String uriAmbiguity$str() {
        return "RESTEASY002195: The following sub-resource methods and sub-resource locators have the same path, [%s].  The paths should be unique.  [%s]";
    }
    @Override
    public final void providerCantBeDynamicallyBoundToMethod(final Class<?> componentClass, final Class<?> providerType) {
        super.log.logf(FQCN, WARN, null, providerCantBeDynamicallyBoundToMethod$str(), componentClass, providerType);
    }
    protected String providerCantBeDynamicallyBoundToMethod$str() {
        return "RESTEASY002196: Component of type %s can't be dynamically bound to a resource method as a %s provider.";
    }
    @Override
    public final void addingClassResource(final String className, final Class<?> clazz) {
        super.log.logv(FQCN, INFO, null, addingClassResource$str(), className, clazz);
    }
    protected String addingClassResource$str() {
        return "RESTEASY002200: Adding class resource {0} from Application {1}";
    }
    @Override
    public final void addingProviderClass(final String className, final Class<?> clazz) {
        super.log.logv(FQCN, INFO, null, addingProviderClass$str(), className, clazz);
    }
    protected String addingProviderClass$str() {
        return "RESTEASY002205: Adding provider class {0} from Application {1}";
    }
    @Override
    public final void addingProviderSingleton(final String className, final Class<?> application) {
        super.log.logv(FQCN, INFO, null, addingProviderSingleton$str(), className, application);
    }
    protected String addingProviderSingleton$str() {
        return "RESTEASY002210: Adding provider singleton {0} from Application {1}";
    }
    @Override
    public final void addingSingletonProvider(final String className, final Class<?> application) {
        super.log.logv(FQCN, INFO, null, addingSingletonProvider$str(), className, application);
    }
    protected String addingSingletonProvider$str() {
        return "RESTEASY002215: Adding singleton provider {0} from Application {1}";
    }
    @Override
    public final void addingSingletonResource(final String className, final Class<?> application) {
        super.log.logv(FQCN, INFO, null, addingSingletonResource$str(), className, application);
    }
    protected String addingSingletonResource$str() {
        return "RESTEASY002220: Adding singleton resource {0} from Application {1}";
    }
    @Override
    public final void deployingApplication(final String className, final Class<?> clazz) {
        super.log.logv(FQCN, INFO, null, deployingApplication$str(), className, clazz);
    }
    protected String deployingApplication$str() {
        return "RESTEASY002225: Deploying {0}: {1}";
    }
    @Override
    public final void mediaTypeLacksCharset(final MediaType mediaType, final String method) {
        super.log.logv(FQCN, INFO, null, mediaTypeLacksCharset$str(), mediaType, method);
    }
    protected String mediaTypeLacksCharset$str() {
        return "RESTEASY002227: MediaType {0} on {1}() lacks charset. Consider setting charset or turning on context parameter resteasy.add.charset";
    }
    @Override
    public final void unableToCloseEntityStream(final Throwable cause) {
        super.log.logf(FQCN, INFO, cause, unableToCloseEntityStream$str());
    }
    protected String unableToCloseEntityStream$str() {
        return "RESTEASY002230: Unable to close entity stream";
    }
    @Override
    public final void unableToDecodeGZIPBase64(final Throwable cause) {
        super.log.logf(FQCN, INFO, cause, unableToDecodeGZIPBase64$str());
    }
    protected String unableToDecodeGZIPBase64$str() {
        return "RESTEASY002235: Unable to decode GZIP compressed Base64 data";
    }
    @Override
    public final void creatingContextObject(final String key, final String value) {
        super.log.logv(FQCN, DEBUG, null, creatingContextObject$str(), key, value);
    }
    protected String creatingContextObject$str() {
        return "RESTEASY002300: Creating context object <{0} : {1}> ";
    }
    @Override
    public final void failedExecutingDebug(final String method, final String path, final Throwable cause) {
        super.log.logv(FQCN, DEBUG, cause, failedExecutingDebug$str(), method, path);
    }
    protected String failedExecutingDebug$str() {
        return "RESTEASY002305: Failed executing {0} {1}";
    }
    @Override
    public final void failedToExecuteDebug(final Throwable cause) {
        super.log.logf(FQCN, DEBUG, cause, failedToExecuteDebug$str());
    }
    protected String failedToExecuteDebug$str() {
        return "RESTEASY002307: Failed to execute";
    }
    @Override
    public final void inOneWay() {
        super.log.logf(FQCN, DEBUG, null, inOneWay$str());
    }
    protected String inOneWay$str() {
        return "RESTEASY002310: IN ONE WAY!!!!!";
    }
    @Override
    public final void pathInfo(final String path) {
        super.log.logf(FQCN, DEBUG, null, pathInfo$str(), path);
    }
    protected String pathInfo$str() {
        return "RESTEASY002315: PathInfo: %s";
    }
    @Override
    public final void runningJob() {
        super.log.logf(FQCN, DEBUG, null, runningJob$str());
    }
    protected String runningJob$str() {
        return "RESTEASY002320: RUNNING JOB!!!!";
    }
    @Override
    public final void temporaryFileCreated(final String fileName) {
        super.log.logf(FQCN, DEBUG, null, temporaryFileCreated$str(), fileName);
    }
    protected String temporaryFileCreated$str() {
        return "RESTEASY002322: Temporary file %s has been created. Consider deleting after it has been used.";
    }
    @Override
    public final void unableToRetrieveConfigDTDs() {
        super.log.logf(FQCN, DEBUG, null, unableToRetrieveConfigDTDs$str());
    }
    protected String unableToRetrieveConfigDTDs$str() {
        return "RESTEASY002325: Unable to retrieve config: disableDTDs defaults to true";
    }
    @Override
    public final void unableToRetrieveConfigExpand() {
        super.log.logf(FQCN, DEBUG, null, unableToRetrieveConfigExpand$str());
    }
    protected String unableToRetrieveConfigExpand$str() {
        return "RESTEASY002330: Unable to retrieve config: expandEntityReferences defaults to false";
    }
    @Override
    public final void unableToRetrieveConfigSecure() {
        super.log.logf(FQCN, DEBUG, null, unableToRetrieveConfigSecure$str());
    }
    protected String unableToRetrieveConfigSecure$str() {
        return "RESTEASY002335: Unable to retrieve config: enableSecureProcessingFeature defaults to true";
    }
    @Override
    public final void clientSideProcessingFailure(final Throwable cause) {
        super.log.logf(FQCN, DEBUG, cause, clientSideProcessingFailure$str());
    }
    protected String clientSideProcessingFailure$str() {
        return "RESTEASY003337: Client side processing failure.";
    }
}
