/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.sse;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.sse.InboundSseEvent;
import org.jboss.resteasy.plugins.providers.sse.EventByteArrayOutputStream;
import org.jboss.resteasy.plugins.providers.sse.EventInput;
import org.jboss.resteasy.plugins.providers.sse.InboundSseEventImpl;
import org.jboss.resteasy.plugins.providers.sse.SseConstants;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;

public class SseEventInputImpl
implements EventInput,
Closeable {
    private Annotation[] annotations;
    private MediaType mediaType;
    private MultivaluedMap<String, String> httpHeaders;
    private InputStream inputStream;
    private volatile boolean isClosed = false;
    private boolean lastFieldWasData;
    private final String DELIMITER = new String(SseConstants.EVENT_DELIMITER, StandardCharsets.UTF_8);

    public SseEventInputImpl(Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream inputStream) {
        this.annotations = annotations;
        this.mediaType = mediaType;
        this.httpHeaders = httpHeaders;
        this.inputStream = inputStream;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public InboundSseEvent read() throws IllegalStateException {
        byte[] chunk = null;
        try {
            this.lastFieldWasData = false;
            chunk = this.readEvent(this.inputStream);
            if (chunk == null) {
                this.close();
                return null;
            }
        }
        catch (IOException e1) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new RuntimeException(Messages.MESSAGES.readEventException(), e1);
        }
        ByteArrayInputStream entityStream = new ByteArrayInputStream(chunk);
        ByteArrayOutputStream temSave = new ByteArrayOutputStream();
        Charset charset = StandardCharsets.UTF_8;
        if (this.mediaType != null && this.mediaType.getParameters().get("charset") != null) {
            charset = Charset.forName((String)this.mediaType.getParameters().get("charset"));
        }
        InboundSseEventImpl.Builder eventBuilder = new InboundSseEventImpl.Builder(this.annotations, this.mediaType, this.httpHeaders);
        int b = -1;
        SseConstants.EVENT currentState = SseConstants.EVENT.START;
        while ((b = entityStream.read()) != -1) {
            try {
                if (currentState == SseConstants.EVENT.START) {
                    if (b == 13 || b == 10) continue;
                    if (b == 58) {
                        currentState = SseConstants.EVENT.COMMENT;
                        continue;
                    }
                    temSave.write(b);
                    currentState = SseConstants.EVENT.FIELD;
                    continue;
                }
                if (currentState == SseConstants.EVENT.COMMENT) {
                    b = this.readLine(entityStream, 10, temSave);
                    String commentLine = temSave.toString(charset.name());
                    eventBuilder.commentLine(commentLine);
                    temSave.reset();
                    currentState = SseConstants.EVENT.START;
                    continue;
                }
                if (currentState != SseConstants.EVENT.FIELD) continue;
                temSave.write(b);
                b = this.readLine(entityStream, 58, temSave);
                String fieldName = temSave.toString(StandardCharsets.UTF_8.name());
                temSave.reset();
                if (b == 58) {
                    while ((b = entityStream.read()) == 32) {
                    }
                    if (b != 10 && b != 13 && b != -1) {
                        temSave.write(b);
                        b = this.readLine(entityStream, 10, temSave);
                    }
                }
                this.processField(eventBuilder, fieldName, this.mediaType, temSave.toByteArray());
                temSave.reset();
                currentState = SseConstants.EVENT.START;
            }
            catch (IOException e) {
                throw new RuntimeException(Messages.MESSAGES.readEventException(), e);
            }
        }
        return eventBuilder.build();
    }

    private int readLine(InputStream in, int delimiter, OutputStream out) throws IOException {
        int b;
        while ((b = in.read()) != -1 && b != delimiter && b != 10 && b != 13) {
            if (out == null) continue;
            out.write(b);
        }
        return b;
    }

    private void processField(InboundSseEventImpl.Builder inboundEventBuilder, String name, MediaType mediaType, byte[] value) {
        Charset charset = StandardCharsets.UTF_8;
        if (mediaType != null && mediaType.getParameters().get("charset") != null) {
            charset = Charset.forName((String)mediaType.getParameters().get("charset"));
        }
        String valueString = new String(value, charset);
        boolean newLastFieldWasData = false;
        if ("event".equals(name)) {
            inboundEventBuilder.name(valueString);
        } else if ("data".equals(name)) {
            if (this.lastFieldWasData) {
                inboundEventBuilder.write(SseConstants.EOL);
            }
            inboundEventBuilder.write(value);
            newLastFieldWasData = true;
        } else if ("id".equals(name)) {
            inboundEventBuilder.id(valueString);
        } else if ("retry".equals(name)) {
            try {
                inboundEventBuilder.reconnectDelay(Long.parseLong(valueString));
            }
            catch (NumberFormatException ex) {
                LogMessages.LOGGER.skipIllegalField("retry", valueString);
            }
        } else {
            LogMessages.LOGGER.skipUnkownFiled(name);
        }
        this.lastFieldWasData = newLastFieldWasData;
    }

    public byte[] readEvent(InputStream in) throws IOException {
        int data;
        EventByteArrayOutputStream buffer = new EventByteArrayOutputStream();
        int pos = 0;
        boolean boundary = false;
        byte[] eolBuffer = new byte[5];
        while ((data = in.read()) != -1) {
            byte b = (byte)data;
            if (b == 13 || b == 10) {
                eolBuffer[pos] = b;
                if (pos > 0 && eolBuffer[pos] == eolBuffer[pos - 1] || pos >= 3 && new String(eolBuffer, 0, pos, StandardCharsets.UTF_8).contains(this.DELIMITER)) {
                    boundary = true;
                }
                if (pos++ > 4) {
                    boundary = true;
                }
            } else {
                pos = 0;
            }
            buffer.write(b);
            if (boundary && buffer.size() > pos) {
                return buffer.getEventPayLoad();
            }
            if (!boundary || buffer.size() != pos) continue;
            pos = 0;
            boundary = false;
            buffer.reset();
        }
        return null;
    }
}

