/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.skeleton.key;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.jboss.resteasy.skeleton.key.BouncyIntegration;
import org.jboss.resteasy.skeleton.key.DerUtils;
import org.jboss.resteasy.util.Base64;

public class PemUtils {
    public static X509Certificate decodeCertificate(InputStream is) throws Exception {
        byte[] der = PemUtils.pemToDer(is);
        ByteArrayInputStream bis = new ByteArrayInputStream(der);
        return DerUtils.decodeCertificate(bis);
    }

    public static X509Certificate decodeCertificate(String cert) throws Exception {
        byte[] der = PemUtils.pemToDer(cert);
        ByteArrayInputStream bis = new ByteArrayInputStream(der);
        return DerUtils.decodeCertificate(bis);
    }

    public static PublicKey decodePublicKey(String pem) throws Exception {
        byte[] der = PemUtils.pemToDer(pem);
        return DerUtils.decodePublicKey(der);
    }

    public static PrivateKey decodePrivateKey(String pem) throws Exception {
        byte[] der = PemUtils.pemToDer(pem);
        return DerUtils.decodePrivateKey(der);
    }

    public static PrivateKey decodePrivateKey(InputStream is) throws Exception {
        String pem = PemUtils.pemFromStream(is);
        return PemUtils.decodePrivateKey(pem);
    }

    public static byte[] pemToDer(InputStream is) throws IOException {
        String pem = PemUtils.pemFromStream(is);
        byte[] der = PemUtils.pemToDer(pem);
        return der;
    }

    public static byte[] pemToDer(String pem) throws IOException {
        pem = PemUtils.removeBeginEnd(pem);
        return Base64.decode((String)pem);
    }

    public static String removeBeginEnd(String pem) {
        pem = pem.replaceAll("-----BEGIN (.*)-----", "");
        pem = pem.replaceAll("-----END (.*)----", "");
        pem = pem.replaceAll("\r\n", "");
        pem = pem.replaceAll("\n", "");
        return pem.trim();
    }

    public static String pemFromStream(InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        byte[] keyBytes = new byte[dis.available()];
        dis.readFully(keyBytes);
        dis.close();
        return new String(keyBytes, StandardCharsets.UTF_8);
    }

    static {
        BouncyIntegration.init();
    }
}

