/*
 * Decompiled with CFR 0.152.
 */
package javax.ws.rs.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.LambdaMetafactory;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

final class FactoryFinder {
    private static final Logger LOGGER = Logger.getLogger(FactoryFinder.class.getName());
    private static final String RESTEASY_JAXRS_API_MODULE = "org.jboss.resteasy.resteasy-jaxrs-api";

    private FactoryFinder() {
    }

    static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(() -> {
            ClassLoader cl = null;
            try {
                cl = Thread.currentThread().getContextClassLoader();
            }
            catch (SecurityException ex) {
                LOGGER.log(Level.WARNING, "Unable to get context classloader instance.", ex);
            }
            return cl;
        });
    }

    private static Object newInstance(String className, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            Class<?> spiClass;
            if (classLoader == null) {
                spiClass = Class.forName(className);
            } else {
                try {
                    spiClass = Class.forName(className, false, classLoader);
                }
                catch (ClassNotFoundException ex) {
                    LOGGER.log(Level.FINE, "Unable to load provider class " + className + " using custom classloader " + classLoader.getClass().getName() + " trying again with current classloader.", ex);
                    spiClass = Class.forName(className);
                }
            }
            return spiClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException x) {
            throw x;
        }
        catch (Exception x) {
            throw new ClassNotFoundException("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static <T> Object find(String factoryId, String fallbackClassName, Class<T> service) throws ClassNotFoundException {
        block64: {
            classLoader = FactoryFinder.getContextClassLoader();
            smEnabled = System.getSecurityManager() != null;
            try {
                iterator = ServiceLoader.load(service, classLoader).iterator();
                if (smEnabled) {
                    result = AccessController.doPrivileged((PrivilegedExceptionAction<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$find$1(java.util.Iterator ), ()Ljava/lang/Object;)(iterator));
                    if (result != null) {
                        return result;
                    }
                } else if (iterator.hasNext()) {
                    return iterator.next();
                }
            }
            catch (Exception | ServiceConfigurationError ex) {
                FactoryFinder.LOGGER.log(Level.FINER, "Failed to load service " + factoryId + ".", ex);
            }
            try {
                iterator = ServiceLoader.load(service, FactoryFinder.class.getClassLoader()).iterator();
                if (smEnabled) {
                    result = AccessController.doPrivileged((PrivilegedExceptionAction<Object>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$find$2(java.util.Iterator ), ()Ljava/lang/Object;)(iterator));
                    if (result != null) {
                        return result;
                    }
                } else if (iterator.hasNext()) {
                    return iterator.next();
                }
            }
            catch (Exception | ServiceConfigurationError ex) {
                FactoryFinder.LOGGER.log(Level.FINER, "Failed to load service " + factoryId + ".", ex);
            }
            inputStream = null;
            configFile = null;
            try {
                javah = System.getProperty("java.home");
                configFile = javah + File.separator + "lib" + File.separator + "jaxrs.properties";
                f = new File(configFile);
                if (!f.exists()) ** GOTO lbl63
                props = new Properties();
                inputStream = new FileInputStream(f);
                props.load(inputStream);
                factoryClassName = props.getProperty(factoryId);
                var11_20 = FactoryFinder.newInstance(factoryClassName, classLoader);
                if (inputStream == null) return var11_20;
                ** GOTO lbl57
            }
            catch (Exception ex) {
                try {
                    FactoryFinder.LOGGER.log(Level.FINER, "Failed to load service " + factoryId + " from $java.home/lib/jaxrs.properties", ex);
                    if (inputStream != null) {
                    }
                }
                catch (Throwable var13_26) {
                    if (inputStream == null) throw var13_26;
                    try {
                        inputStream.close();
                        throw var13_26;
                    }
                    catch (IOException ex) {
                        FactoryFinder.LOGGER.log(Level.FINER, String.format("Error closing %s file.", new Object[]{configFile}), ex);
                    }
                    throw var13_26;
                }
lbl57:
                // 1 sources

                try {
                    inputStream.close();
                    return var11_20;
                }
                catch (IOException ex) {
                    FactoryFinder.LOGGER.log(Level.FINER, String.format("Error closing %s file.", new Object[]{configFile}), ex);
                }
                return var11_20;
lbl63:
                // 1 sources

                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ex) {
                        FactoryFinder.LOGGER.log(Level.FINER, String.format("Error closing %s file.", new Object[]{configFile}), ex);
                    }
                }
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    FactoryFinder.LOGGER.log(Level.FINER, String.format("Error closing %s file.", new Object[]{configFile}), ex);
                }
            }
            try {
                systemProp = System.getProperty(factoryId);
                if (systemProp != null) {
                    return FactoryFinder.newInstance(systemProp, classLoader);
                }
            }
            catch (SecurityException se) {
                FactoryFinder.LOGGER.log(Level.FINER, "Failed to load service " + factoryId + " from a system property", se);
            }
            moduleClassLoader = FactoryFinder.getModuleClassLoader();
            if (moduleClassLoader != null) {
                serviceId = "META-INF/services/" + factoryId;
                try {
                    is = moduleClassLoader.getResourceAsStream(serviceId);
                    var10_19 = null;
                    try {
                        if (is == null) break block64;
                        rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                        var12_25 = null;
                        try {
                            factoryClassName = rd.readLine();
                            if (factoryClassName != null && !"".equals(factoryClassName)) {
                                var14_31 = FactoryFinder.newInstance(factoryClassName, moduleClassLoader);
                                return var14_31;
                            }
                        }
                        catch (Throwable var13_29) {
                            var12_25 = var13_29;
                            throw var13_29;
                        }
                        finally {
                            if (rd != null) {
                                if (var12_25 != null) {
                                    try {
                                        rd.close();
                                    }
                                    catch (Throwable var15_32) {
                                        var12_25.addSuppressed(var15_32);
                                    }
                                } else {
                                    rd.close();
                                }
                            }
                        }
                    }
                    catch (Throwable var11_23) {
                        var10_19 = var11_23;
                        throw var11_23;
                    }
                    finally {
                        if (is != null) {
                            if (var10_19 != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable var15_33) {
                                    var10_19.addSuppressed(var15_33);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                }
                catch (Exception var9_17) {
                    // empty catch block
                }
            }
        }
        if (fallbackClassName != null) return FactoryFinder.newInstance(fallbackClassName, classLoader);
        throw new ClassNotFoundException("Provider for " + factoryId + " cannot be found", null);
    }

    private static ClassLoader getModuleClassLoader() {
        try {
            Object module;
            Object moduleLoader;
            final Class<?> moduleClass = Class.forName("org.jboss.modules.Module");
            Class<?> moduleIdentifierClass = Class.forName("org.jboss.modules.ModuleIdentifier");
            Class<?> moduleLoaderClass = Class.forName("org.jboss.modules.ModuleLoader");
            SecurityManager sm = System.getSecurityManager();
            if (sm == null) {
                moduleLoader = moduleClass.getMethod("getBootModuleLoader", new Class[0]).invoke(null, new Object[0]);
            } else {
                try {
                    moduleLoader = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            return moduleClass.getMethod("getBootModuleLoader", new Class[0]).invoke(null, new Object[0]);
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
            }
            try {
                Object moduleIdentifier = moduleIdentifierClass.getMethod("create", String.class).invoke(null, RESTEASY_JAXRS_API_MODULE);
                module = moduleLoaderClass.getMethod("loadModule", moduleIdentifierClass).invoke(moduleLoader, moduleIdentifier);
            }
            catch (Exception e) {
                return null;
            }
            if (sm == null) {
                return (ClassLoader)moduleClass.getMethod("getClassLoader", new Class[0]).invoke(module, new Object[0]);
            }
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() throws Exception {
                        return (ClassLoader)moduleClass.getMethod("getClassLoader", new Class[0]).invoke(module, new Object[0]);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ Object lambda$find$2(Iterator iterator) throws Exception {
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    private static /* synthetic */ Object lambda$find$1(Iterator iterator) throws Exception {
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }
}

