/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.bind.serializer.JsonbSerializer;
import org.eclipse.yasson.internal.ComponentMatcher;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.components.AdapterBinding;
import org.eclipse.yasson.internal.components.SerializerBinding;
import org.eclipse.yasson.internal.model.customization.ComponentBoundCustomization;
import org.eclipse.yasson.internal.serializer.AbstractSerializerBuilder;
import org.eclipse.yasson.internal.serializer.AbstractValueTypeSerializer;
import org.eclipse.yasson.internal.serializer.AdaptedObjectSerializer;
import org.eclipse.yasson.internal.serializer.ByteArrayBase64Serializer;
import org.eclipse.yasson.internal.serializer.ByteArraySerializer;
import org.eclipse.yasson.internal.serializer.CollectionSerializer;
import org.eclipse.yasson.internal.serializer.DefaultSerializers;
import org.eclipse.yasson.internal.serializer.DoubleArraySerializer;
import org.eclipse.yasson.internal.serializer.FloatArraySerializer;
import org.eclipse.yasson.internal.serializer.IntArraySerializer;
import org.eclipse.yasson.internal.serializer.JsonArraySerializer;
import org.eclipse.yasson.internal.serializer.JsonObjectSerializer;
import org.eclipse.yasson.internal.serializer.LongArraySerializer;
import org.eclipse.yasson.internal.serializer.MapSerializer;
import org.eclipse.yasson.internal.serializer.ObjectArraySerializer;
import org.eclipse.yasson.internal.serializer.ObjectSerializer;
import org.eclipse.yasson.internal.serializer.ObjectSerializerProvider;
import org.eclipse.yasson.internal.serializer.OptionalObjectSerializer;
import org.eclipse.yasson.internal.serializer.SerializerProviderWrapper;
import org.eclipse.yasson.internal.serializer.ShortArraySerializer;
import org.eclipse.yasson.internal.serializer.UserSerializerSerializer;

public class SerializerBuilder
extends AbstractSerializerBuilder<SerializerBuilder> {
    private Class<?> objectClass;

    public SerializerBuilder(JsonbContext jsonbContext) {
        super(jsonbContext);
    }

    public SerializerBuilder withObjectClass(Class<?> objectClass) {
        this.objectClass = objectClass;
        return this;
    }

    public JsonbSerializer<?> build() {
        Optional<AbstractValueTypeSerializer<?>> supportedTypeSerializer;
        this.runtimeType = this.resolveRuntimeType();
        if (this.getModel() != null && (this.getModel().getCustomization() == null || this.getModel().getCustomization() instanceof ComponentBoundCustomization)) {
            ComponentBoundCustomization customization = (ComponentBoundCustomization)((Object)this.getModel().getCustomization());
            ComponentMatcher componentMatcher = this.jsonbContext.getComponentMatcher();
            Optional<SerializerBinding<?>> userSerializer = componentMatcher.getSerializerBinding(this.getRuntimeType(), customization);
            if (userSerializer.isPresent() && !this.jsonbContext.containsProcessedType(userSerializer.get().getBindingType())) {
                return new UserSerializerSerializer(this.model, userSerializer.get().getJsonbSerializer());
            }
            Optional<AdapterBinding> adapterInfoOptional = componentMatcher.getAdapterBinding(this.getRuntimeType(), customization);
            if (adapterInfoOptional.isPresent() && !this.jsonbContext.containsProcessedType(adapterInfoOptional.get().getBindingType())) {
                return new AdaptedObjectSerializer(this.getModel(), adapterInfoOptional.get());
            }
        }
        if ((supportedTypeSerializer = this.getSupportedTypeSerializer(this.objectClass)).isPresent()) {
            return supportedTypeSerializer.get();
        }
        if (Collection.class.isAssignableFrom(this.objectClass)) {
            return new CollectionSerializer(this);
        }
        if (Map.class.isAssignableFrom(this.objectClass)) {
            return new MapSerializer(this);
        }
        if (this.isByteArray(this.objectClass)) {
            String strategy;
            switch (strategy = this.jsonbContext.getConfigProperties().getBinaryDataStrategy()) {
                case "BYTE": {
                    return new ByteArraySerializer(this);
                }
            }
            return new ByteArrayBase64Serializer(byte[].class, this.getModel());
        }
        if (this.objectClass.isArray() || this.getRuntimeType() instanceof GenericArrayType) {
            return this.createArrayItem(this.objectClass.getComponentType());
        }
        if (JsonValue.class.isAssignableFrom(this.objectClass)) {
            if (JsonObject.class.isAssignableFrom(this.objectClass)) {
                return new JsonObjectSerializer(this);
            }
            return new JsonArraySerializer(this);
        }
        if (Optional.class.isAssignableFrom(this.objectClass)) {
            return new OptionalObjectSerializer(this);
        }
        this.jsonbContext.getMappingContext().addSerializerProvider(this.objectClass, new ObjectSerializerProvider());
        return new ObjectSerializer(this);
    }

    private boolean isByteArray(Class<?> rawType) {
        return rawType.isArray() && rawType.getComponentType() == Byte.TYPE;
    }

    private JsonbSerializer<?> createArrayItem(Class<?> componentType) {
        if (componentType == Byte.TYPE) {
            return new ByteArraySerializer(this);
        }
        if (componentType == Short.TYPE) {
            return new ShortArraySerializer(this);
        }
        if (componentType == Integer.TYPE) {
            return new IntArraySerializer(this);
        }
        if (componentType == Long.TYPE) {
            return new LongArraySerializer(this);
        }
        if (componentType == Float.TYPE) {
            return new FloatArraySerializer(this);
        }
        if (componentType == Double.TYPE) {
            return new DoubleArraySerializer(this);
        }
        return new ObjectArraySerializer(this);
    }

    private Optional<AbstractValueTypeSerializer<?>> getSupportedTypeSerializer(Class<?> rawType) {
        Optional<SerializerProviderWrapper> supportedTypeSerializerOptional = DefaultSerializers.getInstance().findValueSerializerProvider(rawType);
        if (supportedTypeSerializerOptional.isPresent()) {
            return Optional.of(supportedTypeSerializerOptional.get().getSerializerProvider().provideSerializer(this.getModel()));
        }
        return Optional.empty();
    }

    private Type resolveRuntimeType() {
        if (this.genericType != null && this.genericType != Object.class) {
            return this.genericType;
        }
        if (this.getModel() != null && !(this.getModel().getType() instanceof TypeVariable)) {
            return this.getModel().getType();
        }
        return this.objectClass;
    }
}

