/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.math.BigDecimal;
import java.math.BigInteger;

class BigNumberUtil {
    private static final int MAX_BIT_SIZE = 53;
    private static final int MIN_RANGE = -1022;
    private static final int MAX_RANGE = 1023;

    BigNumberUtil() {
    }

    static boolean isIEEE754(BigDecimal value) {
        int scale = value.scale();
        int valBits = value.unscaledValue().abs().bitLength();
        int intBitsScaled = value.toBigInteger().bitLength();
        return valBits <= 53 && intBitsScaled <= 53 && -1022 <= scale && scale <= 1023;
    }

    static boolean isIEEE754(BigInteger value) {
        return value.abs().bitLength() <= 53;
    }
}

